/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.steps;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.halo.gradle.Assert;
import run.halo.gradle.RetryUtils;

public class ReloadPluginStep {
    private static final Logger log = LoggerFactory.getLogger(ReloadPluginStep.class);
    private final HttpClient client;
    private final String host;

    public ReloadPluginStep(String host, HttpClient client) {
        Assert.notNull(host, "The host must not be null.");
        Assert.notNull(client, "The httpClient must not be null.");
        this.client = client;
        this.host = host;
    }

    public void execute(String pluginName, File file) {
        try {
            this.reloadPlugin(this.client, pluginName);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private URI buildUri(String endpoint) {
        String path = StringUtils.prependIfMissing((String)endpoint, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        String hostPrepared = StringUtils.removeEnd((String)this.host, (String)"/");
        try {
            return new URI(hostPrepared + path);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isSuccessful(HttpResponse<String> response) {
        return response.statusCode() >= 200 && response.statusCode() < 300;
    }

    private boolean is404(HttpResponse<String> response) {
        return response.statusCode() == 404;
    }

    private void reloadPlugin(HttpClient client, String pluginName) throws IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder().uri(this.buildUri("/apis/api.console.halo.run/v1alpha1/plugins/" + pluginName + "/reload")).PUT(HttpRequest.BodyPublishers.ofString("")).build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        if (this.isSuccessful(response)) {
            log.info("Reload plugin successfully.");
        } else {
            log.error("Reload plugin failed, [{}].", (Object)response.body());
        }
    }

    private void installPlugin(HttpClient client, File pluginFile) throws IOException, InterruptedException {
        String multipartFormDataBoundary = "Java11HttpClientFormBoundary";
        HttpRequest installRequest = HttpRequest.newBuilder().uri(this.buildUri("/apis/api.console.halo.run/v1alpha1/plugins/install")).header("Content-Type", "multipart/form-data; boundary=Java11HttpClientFormBoundary").POST(HttpRequest.BodyPublishers.ofInputStream(() -> {
            ByteArrayInputStream byteArrayInputStream;
            block8: {
                HttpEntity file = MultipartEntityBuilder.create().addPart("file", (ContentBody)new FileBody(pluginFile, ContentType.DEFAULT_BINARY)).setBoundary(multipartFormDataBoundary).build();
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    file.writeTo((OutputStream)byteArrayOutputStream);
                    byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                    if (file == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (file != null) {
                            try {
                                file.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                file.close();
            }
            return byteArrayInputStream;
        })).build();
        HttpResponse<String> response = client.send(installRequest, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        if (this.isSuccessful(response)) {
            log.info("Install plugin successfully.");
        } else {
            log.error("Install plugin failed, [{}].", (Object)response.body());
        }
    }

    private void uninstallPlugin(HttpClient client, String pluginName) throws IOException, InterruptedException {
        HttpRequest uninstallRequest = HttpRequest.newBuilder().uri(this.buildUri("/apis/plugin.halo.run/v1alpha1/plugins/" + pluginName)).DELETE().build();
        HttpResponse<String> response = client.send(uninstallRequest, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        if (!this.isSuccessful(response)) {
            throw new IllegalStateException("Uninstall plugin failed," + response.body());
        }
        this.waitForUninstall(client, pluginName);
        log.info("Uninstall plugin successfully.");
    }

    private void waitForUninstall(HttpClient client, String pluginName) {
        HttpRequest request = HttpRequest.newBuilder().uri(this.buildUri("/apis/plugin.halo.run/v1alpha1/plugins/" + pluginName)).GET().build();
        RetryUtils.withRetry(20, 500L, () -> {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            return this.is404(response);
        });
    }

    private boolean checkPluginExists(HttpClient client, String pluginName) throws IOException, InterruptedException {
        HttpRequest getPluginRequest = HttpRequest.newBuilder().uri(this.buildUri("/apis/plugin.halo.run/v1alpha1/plugins/" + pluginName)).GET().build();
        HttpResponse<String> response = client.send(getPluginRequest, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        return this.isSuccessful(response);
    }
}

