/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.watch;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.halo.gradle.watch.Watcher;

public class DefaultWatcher
implements Watcher {
    private static final WatchEvent.Kind[] EVENT_KIND = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE};
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWatcher.class);
    private final WatchService service = FileSystems.getDefault().newWatchService();
    private final Map<Path, WatchKey> paths = new LinkedHashMap<Path, WatchKey>();
    private boolean closed;

    Set<Path> getPaths() {
        return Collections.unmodifiableSet(this.paths.keySet());
    }

    @Override
    public void register(Path path) throws IOException {
        if (this.closed) {
            throw new ClosedWatchServiceException();
        }
        if (!Files.exists(path, new LinkOption[0])) {
            throw new NoSuchFileException(path.toString());
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            Path dir = path.getParent();
            this.paths.put(dir, dir.register(this.service, EVENT_KIND, SensitivityWatchEventModifier.HIGH));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} is registered.", (Object)dir);
            }
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                DefaultWatcher.this.paths.put(dir, dir.register(DefaultWatcher.this.service, EVENT_KIND, SensitivityWatchEventModifier.HIGH));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{} is registered.", (Object)dir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @Override
    public void unregister(Path path) throws IOException {
        if (this.closed) {
            throw new ClosedWatchServiceException();
        }
        Iterator<Map.Entry<Path, WatchKey>> it = this.paths.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Path, WatchKey> e = it.next();
            Path p = e.getKey();
            if (!p.startsWith(path)) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} is unregistered", (Object)p);
            }
            e.getValue().cancel();
            it.remove();
        }
        for (Map.Entry<Path, WatchKey> e : this.paths.entrySet()) {
            if (e.getValue().isValid()) continue;
            Path p = e.getKey();
            this.paths.put(p, p.register(this.service, EVENT_KIND, SensitivityWatchEventModifier.HIGH));
        }
    }

    @Override
    public boolean isWatching(Path path) {
        return this.paths.containsKey(path);
    }

    @Override
    public WatchKey take() throws InterruptedException {
        if (this.closed) {
            throw new ClosedWatchServiceException();
        }
        return this.service.take();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.paths.clear();
        this.service.close();
    }
}

