/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.watch;

import java.io.File;
import java.io.FileFilter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import run.halo.gradle.Assert;
import run.halo.gradle.watch.ChangedFiles;
import run.halo.gradle.watch.DirectorySnapshot;
import run.halo.gradle.watch.FileChangeListener;
import run.halo.gradle.watch.SnapshotStateRepository;

public class FileSystemWatcher {
    private static final Duration DEFAULT_POLL_INTERVAL = Duration.ofMillis(1000L);
    private static final Duration DEFAULT_QUIET_PERIOD = Duration.ofMillis(400L);
    private final List<FileChangeListener> listeners = new ArrayList<FileChangeListener>();
    private final boolean daemon;
    private final long pollInterval;
    private final long quietPeriod;
    private final SnapshotStateRepository snapshotStateRepository;
    private final AtomicInteger remainingScans = new AtomicInteger(-1);
    private final Map<File, DirectorySnapshot> directories = new HashMap<File, DirectorySnapshot>();
    private Thread watchThread;
    private FileFilter triggerFilter;
    private FileFilter excludeFileFilter;
    private final Object monitor = new Object();

    public FileSystemWatcher() {
        this(true, DEFAULT_POLL_INTERVAL, DEFAULT_QUIET_PERIOD);
    }

    public FileSystemWatcher(boolean daemon, Duration pollInterval, Duration quietPeriod) {
        this(daemon, pollInterval, quietPeriod, null);
    }

    public FileSystemWatcher(boolean daemon, Duration pollInterval, Duration quietPeriod, SnapshotStateRepository snapshotStateRepository) {
        Assert.notNull(pollInterval, "PollInterval must not be null");
        Assert.notNull(quietPeriod, "QuietPeriod must not be null");
        Assert.isTrue(pollInterval.toMillis() > 0L, "PollInterval must be positive");
        Assert.isTrue(quietPeriod.toMillis() > 0L, "QuietPeriod must be positive");
        Assert.isTrue(pollInterval.toMillis() > quietPeriod.toMillis(), "PollInterval must be greater than QuietPeriod");
        this.daemon = daemon;
        this.pollInterval = pollInterval.toMillis();
        this.quietPeriod = quietPeriod.toMillis();
        this.snapshotStateRepository = snapshotStateRepository != null ? snapshotStateRepository : SnapshotStateRepository.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(FileChangeListener fileChangeListener) {
        Assert.notNull(fileChangeListener, "FileChangeListener must not be null");
        Object object = this.monitor;
        synchronized (object) {
            this.checkNotStarted();
            this.listeners.add(fileChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceDirectories(Iterable<File> directories) {
        Assert.notNull(directories, "Directories must not be null");
        Object object = this.monitor;
        synchronized (object) {
            directories.forEach(this::addSourceDirectory);
        }
    }

    public void setExcludeFileFilter(FileFilter excludeFileFilter) {
        this.excludeFileFilter = excludeFileFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceDirectory(File directory) {
        Assert.notNull(directory, "Directory must not be null");
        Assert.isTrue(!directory.isFile(), () -> "Directory '" + directory + "' must not be a file");
        Object object = this.monitor;
        synchronized (object) {
            this.checkNotStarted();
            this.directories.put(directory, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTriggerFilter(FileFilter triggerFilter) {
        Object object = this.monitor;
        synchronized (object) {
            this.triggerFilter = triggerFilter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNotStarted() {
        Object object = this.monitor;
        synchronized (object) {
            Assert.state(this.watchThread == null, "FileSystemWatcher already started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.monitor;
        synchronized (object) {
            this.createOrRestoreInitialSnapshots();
            if (this.watchThread == null) {
                HashMap<File, DirectorySnapshot> localDirectories = new HashMap<File, DirectorySnapshot>(this.directories);
                Watcher watcher = new Watcher(this.remainingScans, new ArrayList<FileChangeListener>(this.listeners), this.triggerFilter, this.excludeFileFilter, this.pollInterval, this.quietPeriod, localDirectories, this.snapshotStateRepository);
                this.watchThread = new Thread(watcher);
                this.watchThread.setName("File Watcher");
                this.watchThread.setDaemon(this.daemon);
                this.watchThread.start();
            }
        }
    }

    private void createOrRestoreInitialSnapshots() {
        Map restored = (Map)this.snapshotStateRepository.restore();
        this.directories.replaceAll((f, v) -> {
            DirectorySnapshot restoredSnapshot = restored != null ? (DirectorySnapshot)restored.get(f) : null;
            return restoredSnapshot != null ? restoredSnapshot : new DirectorySnapshot((File)f, this.excludeFileFilter);
        });
    }

    public void stop() {
        this.stopAfter(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopAfter(int remainingScans) {
        Thread thread;
        Object object = this.monitor;
        synchronized (object) {
            thread = this.watchThread;
            if (thread != null) {
                this.remainingScans.set(remainingScans);
                if (remainingScans <= 0) {
                    thread.interrupt();
                }
            }
            this.watchThread = null;
        }
        if (thread != null && Thread.currentThread() != thread) {
            try {
                thread.join();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static final class Watcher
    implements Runnable {
        private final AtomicInteger remainingScans;
        private final List<FileChangeListener> listeners;
        private final FileFilter triggerFilter;
        private final FileFilter excludeFileFilter;
        private final long pollInterval;
        private final long quietPeriod;
        private Map<File, DirectorySnapshot> directories;
        private final SnapshotStateRepository snapshotStateRepository;

        private Watcher(AtomicInteger remainingScans, List<FileChangeListener> listeners, FileFilter triggerFilter, FileFilter excludeFileFilter, long pollInterval, long quietPeriod, Map<File, DirectorySnapshot> directories, SnapshotStateRepository snapshotStateRepository) {
            this.remainingScans = remainingScans;
            this.listeners = listeners;
            this.triggerFilter = triggerFilter;
            this.excludeFileFilter = excludeFileFilter;
            this.pollInterval = pollInterval;
            this.quietPeriod = quietPeriod;
            this.directories = directories;
            this.snapshotStateRepository = snapshotStateRepository;
        }

        @Override
        public void run() {
            int remainingScans = this.remainingScans.get();
            while (remainingScans > 0 || remainingScans == -1) {
                try {
                    if (remainingScans > 0) {
                        this.remainingScans.decrementAndGet();
                    }
                    this.scan();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                remainingScans = this.remainingScans.get();
            }
        }

        private void scan() throws InterruptedException {
            Map<File, DirectorySnapshot> previous;
            Thread.sleep(this.pollInterval - this.quietPeriod);
            Map<File, DirectorySnapshot> current = this.directories;
            do {
                previous = current;
                current = this.getCurrentSnapshots();
                Thread.sleep(this.quietPeriod);
            } while (this.isDifferent(previous, current));
            if (this.isDifferent(this.directories, current)) {
                this.updateSnapshots(current.values());
            }
        }

        private boolean isDifferent(Map<File, DirectorySnapshot> previous, Map<File, DirectorySnapshot> current) {
            if (!previous.keySet().equals(current.keySet())) {
                return true;
            }
            for (Map.Entry<File, DirectorySnapshot> entry : previous.entrySet()) {
                DirectorySnapshot currentDirectory;
                DirectorySnapshot previousDirectory = entry.getValue();
                if (previousDirectory.equals(currentDirectory = current.get(entry.getKey()), this.triggerFilter)) continue;
                return true;
            }
            return false;
        }

        private Map<File, DirectorySnapshot> getCurrentSnapshots() {
            LinkedHashMap<File, DirectorySnapshot> snapshots = new LinkedHashMap<File, DirectorySnapshot>();
            for (File directory : this.directories.keySet()) {
                DirectorySnapshot directorySnapshot = new DirectorySnapshot(directory, this.excludeFileFilter);
                snapshots.put(directory, directorySnapshot);
            }
            return snapshots;
        }

        private void updateSnapshots(Collection<DirectorySnapshot> snapshots) {
            LinkedHashMap<File, DirectorySnapshot> updated = new LinkedHashMap<File, DirectorySnapshot>();
            LinkedHashSet<ChangedFiles> changeSet = new LinkedHashSet<ChangedFiles>();
            for (DirectorySnapshot snapshot : snapshots) {
                DirectorySnapshot previous = this.directories.get(snapshot.getDirectory());
                updated.put(snapshot.getDirectory(), snapshot);
                ChangedFiles changedFiles = previous.getChangedFiles(snapshot, this.triggerFilter);
                if (changedFiles.getFiles().isEmpty()) continue;
                changeSet.add(changedFiles);
            }
            this.directories = updated;
            this.snapshotStateRepository.save(updated);
            if (!changeSet.isEmpty()) {
                this.fireListeners(Collections.unmodifiableSet(changeSet));
            }
        }

        private void fireListeners(Set<ChangedFiles> changeSet) {
            for (FileChangeListener listener : this.listeners) {
                listener.onChange(changeSet);
            }
        }
    }
}

