/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.watch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import org.gradle.api.Named;
import org.gradle.api.file.FileCollection;

public class WatchTarget
implements Named {
    private final String name;
    List<FileCollection> files = new ArrayList<FileCollection>();
    Set<String> excludes = new HashSet<String>();

    public WatchTarget(String name) {
        this.name = name;
    }

    public List<FileCollection> getFiles() {
        return this.files;
    }

    public WatchTarget files(FileCollection files) {
        this.files.add(files);
        return this;
    }

    public WatchTarget excludes(String ... excludes) {
        this.excludes.addAll(Arrays.asList(excludes));
        return this;
    }

    public WatchTarget exclude(String exclude) {
        this.excludes.add(exclude);
        return this;
    }

    public Set<String> getExcludes() {
        return this.excludes;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "WatchTarget(name=" + this.getName() + ", files=" + this.getFiles() + ", excludes=" + this.getExcludes() + ")";
    }
}

