/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.watch;

import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.logging.Logging;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.internal.consumer.DefaultBuildLauncher;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.gradle.wrapper.GradleUserHomeLookup;
import org.slf4j.Logger;
import run.halo.gradle.Assert;
import run.halo.gradle.WatchExecutionParameters;
import run.halo.gradle.watch.NoCloseOutputStream;

public class WatchTaskRunner
implements AutoCloseable {
    private static final Logger LOG = Logging.getLogger(WatchTaskRunner.class);
    private final ProjectConnection connection;

    public WatchTaskRunner(Project project) {
        DefaultGradleConnector gradleConnector = (DefaultGradleConnector)GradleConnector.newConnector();
        gradleConnector.useGradleUserHomeDir(project.getGradle().getGradleUserHomeDir());
        gradleConnector.useDistributionBaseDir(GradleUserHomeLookup.gradleUserHome());
        this.connection = gradleConnector.forProjectDirectory(project.getProjectDir()).connect();
    }

    public void run(WatchExecutionParameters parameters) {
        List<String> buildArgs;
        ClassPath injectedClassPath;
        Assert.notNull(parameters, "WatchExecutionParameters must not be null");
        DefaultBuildLauncher launcher = (DefaultBuildLauncher)((BuildLauncher)this.connection.newBuild().setStandardOutput((OutputStream)new NoCloseOutputStream(parameters.getStandardError()))).setStandardError((OutputStream)new NoCloseOutputStream(parameters.getStandardError()));
        if (parameters.getStandardInput() != null) {
            launcher.setStandardInput(parameters.getStandardInput());
        }
        if ((injectedClassPath = parameters.getInjectedClassPath()) != null && !injectedClassPath.isEmpty()) {
            launcher.withInjectedClassPath(injectedClassPath);
        }
        if ((buildArgs = parameters.getBuildArgs()) != null && !buildArgs.isEmpty()) {
            launcher.withArguments(buildArgs);
        }
        launcher.setJvmArguments(parameters.getJvmArgs().toArray(new String[0]));
        launcher.setEnvironmentVariables(parameters.getEnvironment());
        int[] taskNum = new int[1];
        launcher.addProgressListener(event -> {
            if ("Execute tasks".equals(event.getDescription())) {
                taskNum[0] = taskNum[0] + 1;
            }
        });
        System.out.println("Executed " + taskNum[0] + " tasks.");
        try {
            launcher.run();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        this.connection.close();
    }

    private String[] getArguments(StartParameter parameter) {
        ArrayList<CallSite> args = new ArrayList<CallSite>();
        for (Map.Entry e : parameter.getProjectProperties().entrySet()) {
            args.add((CallSite)((Object)("-P" + (String)e.getKey() + "=" + (String)e.getValue())));
        }
        return args.toArray(new String[0]);
    }
}

