/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle;

import java.io.File;
import java.util.Collection;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.build.event.BuildEventListenerRegistryInternal;
import org.gradle.jvm.tasks.Jar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.halo.gradle.HaloExtension;
import run.halo.gradle.HaloPluginExtension;
import run.halo.gradle.HaloServerBuildOperationListener;
import run.halo.gradle.PluginComponentsIndexTask;
import run.halo.gradle.PluginJarManifestCustomizer;
import run.halo.gradle.PluginManifest;
import run.halo.gradle.ReloadPluginTask;
import run.halo.gradle.ResolvePluginMainClassName;
import run.halo.gradle.YamlPluginVersionSupport;
import run.halo.gradle.YamlUtils;
import run.halo.gradle.docker.AbstractDockerRemoteApiTask;
import run.halo.gradle.docker.DockerClientService;
import run.halo.gradle.docker.DockerCreateContainer;
import run.halo.gradle.docker.DockerPullImage;
import run.halo.gradle.docker.DockerRemoveContainer;
import run.halo.gradle.docker.DockerStartContainer;
import run.halo.gradle.watch.WatchTask;

public class HaloDevtoolsPlugin
implements Plugin<Project> {
    private static final Logger log = LoggerFactory.getLogger(HaloDevtoolsPlugin.class);
    public static final String GROUP = "halo server";
    public static final String DEVELOPMENT_ONLY_CONFIGURATION_NAME = "developmentOnly";
    public static final String PRODUCTION_RUNTIME_CLASSPATH_CONFIGURATION_NAME = "productionRuntimeClasspath";
    private final BuildEventListenerRegistryInternal buildEvents;

    @Inject
    public HaloDevtoolsPlugin(BuildEventListenerRegistryInternal buildEvents) {
        this.buildEvents = buildEvents;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(JavaPlugin.class);
        log.info("Halo plugin development gradle plugin run...");
        HaloExtension haloExtension = (HaloExtension)project.getExtensions().create("halo", HaloExtension.class, new Object[]{project.getObjects()});
        HaloPluginExtension pluginExtension = (HaloPluginExtension)project.getExtensions().create("haloPlugin", HaloPluginExtension.class, new Object[]{project});
        pluginExtension.setWorkDir(project.getProjectDir().toPath().resolve("workplace"));
        File manifestFile = this.getPluginManifest(project);
        pluginExtension.setManifestFile(manifestFile);
        PluginManifest pluginManifest = YamlUtils.read(manifestFile, PluginManifest.class);
        pluginExtension.setRequires(pluginManifest.getSpec().getRequires());
        pluginExtension.setPluginName(pluginManifest.getMetadata().getName());
        if (StringUtils.isBlank((CharSequence)pluginManifest.getMetadata().getName())) {
            throw new IllegalStateException("Plugin name must not be blank.");
        }
        pluginExtension.setVersion((String)project.getVersion());
        System.setProperty("halo.plugin.name", pluginManifest.getMetadata().getName());
        Action<Task> yamlVersionAction = YamlPluginVersionSupport.configurePluginYamlVersion(project, manifestFile);
        project.getTasks().register("generatePluginComponentsIdx", PluginComponentsIndexTask.class, it -> {
            it.setGroup(GROUP);
            FileCollection files = ((SourceSet)((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("main")).getOutput().getClassesDirs();
            it.classesDirs.from(new Object[]{files});
            it.doFirst(yamlVersionAction);
        });
        project.getTasks().getByName("jar").dependsOn(new Object[]{"generatePluginComponentsIdx"});
        TaskProvider<ResolvePluginMainClassName> resolvePluginMainClassName = this.configureResolvePluginMainClassNameTask(project);
        this.configurePluginJarTask(project, resolvePluginMainClassName);
        project.afterEvaluate(action -> {
            this.configureReloadPluginTask(project, pluginExtension.getPluginName());
            HaloExtension.Docker dockerExtension = haloExtension.getDocker();
            Provider serviceProvider = project.getGradle().getSharedServices().registerIfAbsent("docker", DockerClientService.class, pBuildServiceSpec -> pBuildServiceSpec.parameters(parameters -> {
                parameters.getUrl().set(dockerExtension.getUrl());
                parameters.getApiVersion().set(dockerExtension.getApiVersion());
            }));
            String imageName = haloExtension.getImageName() + ":" + haloExtension.getVersion();
            project.getTasks().create("pullHaloImage", DockerPullImage.class, it -> {
                it.getImage().set((Object)imageName);
                it.setGroup(GROUP);
                it.setDescription("Pull halo server image from docker hub.");
            });
            DockerCreateContainer createContainer = (DockerCreateContainer)project.getTasks().create("createHaloContainer", DockerCreateContainer.class, it -> {
                it.getImageId().set((Object)imageName);
                it.getContainerName().set((Object)haloExtension.getContainerName());
                it.setGroup(GROUP);
                it.setDescription("Create halo server container.");
                it.dependsOn(new Object[]{"build", "pullHaloImage"});
            });
            project.getTasks().create("removeHaloContainer", DockerRemoveContainer.class, it -> {
                it.getForce().set((Object)true);
                it.getContainerId().set(createContainer.getContainerId());
                it.setGroup(GROUP);
                it.setDescription("Remove halo server container.");
            });
            project.getTasks().create("haloServer", DockerStartContainer.class, it -> {
                it.setGroup(GROUP);
                it.getContainerId().set(createContainer.getContainerId());
                it.dependsOn(new Object[]{"createHaloContainer"});
                it.setDescription("Run halo server container.");
            });
            project.getTasks().create("watch", WatchTask.class, it -> {
                it.setGroup(GROUP);
                it.getContainerId().set(createContainer.getContainerId());
                it.dependsOn(new Object[]{"createHaloContainer"});
            });
            project.getTasks().withType(AbstractDockerRemoteApiTask.class).configureEach(task -> task.getDockerClientService().set(serviceProvider));
            Provider haloServerBuildOperationListenerProvider = project.getGradle().getSharedServices().registerIfAbsent("halo-server-build-operation-listener", HaloServerBuildOperationListener.class, builderServiceSpec -> builderServiceSpec.parameters(parameters -> {
                parameters.getDockerClientService().set(serviceProvider);
                File containerIdFile = new File((File)project.getLayout().getBuildDirectory().getAsFile().get(), ".docker/createHaloContainer-containerId.txt");
                parameters.getContainerId().set((Object)containerIdFile);
            }));
            this.buildEvents.onOperationCompletion(haloServerBuildOperationListenerProvider);
        });
    }

    private TaskProvider<ReloadPluginTask> configureReloadPluginTask(Project project, String pluginName) {
        return project.getTasks().register("reloadPlugin", ReloadPluginTask.class, reloadTask -> {
            reloadTask.setDescription("Reloads the plugin by name.");
            reloadTask.setGroup(GROUP);
            reloadTask.dependsOn(new Object[]{"build"});
            reloadTask.getPluginName().set((Object)pluginName);
        });
    }

    private TaskProvider<ResolvePluginMainClassName> configureResolvePluginMainClassNameTask(Project project) {
        return project.getTasks().register("resolvePluginMainClassName", ResolvePluginMainClassName.class, resolveMainClassName -> {
            resolveMainClassName.setDescription("Resolves the name of the plugin's main class.");
            resolveMainClassName.setGroup(GROUP);
            Callable<FileCollection> classpath = () -> ((SourceSet)((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("main")).getOutput();
            resolveMainClassName.setClasspath(classpath);
            resolveMainClassName.getConfiguredMainClassName().convention(project.provider(() -> {
                HaloPluginExtension haloPluginExtension = (HaloPluginExtension)project.getExtensions().getByType(HaloPluginExtension.class);
                return (String)haloPluginExtension.getMainClass().getOrNull();
            }));
            resolveMainClassName.getOutputFile().set(project.getLayout().getBuildDirectory().file("resolvedMainClassName"));
        });
    }

    private void configurePluginJarTask(Project project, TaskProvider<ResolvePluginMainClassName> resolveMainClassName) {
        this.configureDevelopmentOnlyConfiguration(project);
        SourceSet mainSourceSet = (SourceSet)this.javaPluginExtension(project).getSourceSets().getByName("main");
        Configuration developmentOnly = project.getConfigurations().getByName(DEVELOPMENT_ONLY_CONFIGURATION_NAME);
        Configuration productionRuntimeClasspath = project.getConfigurations().getByName(PRODUCTION_RUNTIME_CLASSPATH_CONFIGURATION_NAME);
        Callable<FileCollection> classpath = () -> mainSourceSet.getRuntimeClasspath().minus(developmentOnly.minus((FileCollection)productionRuntimeClasspath));
        project.getTasks().named("jar", Jar.class).configure(jar -> {
            PluginJarManifestCustomizer customizer = new PluginJarManifestCustomizer(project);
            Provider manifestStartClass = project.provider(() -> (String)jar.getManifest().getAttributes().get((Object)"Plugin-Main-Class"));
            customizer.getMainClass().convention(resolveMainClassName.flatMap(resolver -> manifestStartClass.isPresent() ? manifestStartClass : ((ResolvePluginMainClassName)((Object)((Object)((Object)resolveMainClassName.get())))).readMainClassName()));
            customizer.getTargetJavaVersion().set(project.provider(() -> this.javaPluginExtension(project).getTargetCompatibility()));
            customizer.classpath(classpath);
            customizer.configureManifest(jar.getManifest());
            jar.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
            customizer.configureJarArchiveFilesSpec((Jar)jar);
        });
    }

    private void configureDevelopmentOnlyConfiguration(Project project) {
        Configuration developmentOnly = (Configuration)project.getConfigurations().create(DEVELOPMENT_ONLY_CONFIGURATION_NAME);
        Configuration runtimeClasspath = project.getConfigurations().getByName("runtimeClasspath");
        Configuration productionRuntimeClasspath = (Configuration)project.getConfigurations().create(PRODUCTION_RUNTIME_CLASSPATH_CONFIGURATION_NAME);
        AttributeContainer attributes = productionRuntimeClasspath.getAttributes();
        ObjectFactory objectFactory = project.getObjects();
        attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)objectFactory.named(Usage.class, "java-runtime")));
        attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)objectFactory.named(Bundling.class, "external")));
        attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)objectFactory.named(LibraryElements.class, "jar")));
        productionRuntimeClasspath.setVisible(false);
        productionRuntimeClasspath.setExtendsFrom((Iterable)runtimeClasspath.getExtendsFrom());
        productionRuntimeClasspath.setCanBeResolved(runtimeClasspath.isCanBeResolved());
        productionRuntimeClasspath.setCanBeConsumed(runtimeClasspath.isCanBeConsumed());
        runtimeClasspath.extendsFrom(new Configuration[]{developmentOnly});
    }

    private JavaPluginExtension javaPluginExtension(Project project) {
        return (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
    }

    private File getPluginManifest(Project project) {
        SourceSetContainer sourceSetContainer = (SourceSetContainer)project.getProperties().get("sourceSets");
        File mainResourceDir = (File)sourceSetContainer.stream().filter(set -> "main".equals(set.getName())).map(SourceSet::getResources).map(SourceDirectorySet::getSrcDirs).flatMap(Collection::stream).findFirst().orElseThrow();
        for (String filename : HaloPluginExtension.MANIFEST) {
            File manifestFile = new File(mainResourceDir, filename);
            if (!manifestFile.exists()) continue;
            return manifestFile;
        }
        throw new IllegalStateException("The plugin manifest file [plugin.yaml] not found in " + mainResourceDir);
    }

    public BuildEventListenerRegistryInternal getBuildEvents() {
        return this.buildEvents;
    }
}

