/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.RemoveContainerCmd;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.file.Directory;
import org.gradle.api.internal.tasks.execution.ExecuteTaskBuildOperationDetails;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import run.halo.gradle.docker.DockerClientConfiguration;
import run.halo.gradle.docker.DockerClientService;

public abstract class HaloServerBuildOperationListener
implements BuildService<Params>,
BuildOperationListener {
    private static final Set<String> SUPPORTED_TASK_NAME = Set.of("haloServer", "watch");

    public void started(@Nonnull BuildOperationDescriptor buildOperation, @Nonnull OperationStartEvent startEvent) {
    }

    public void progress(@Nonnull OperationIdentifier operationIdentifier, @Nonnull OperationProgressEvent progressEvent) {
    }

    public void finished(BuildOperationDescriptor buildOperation, @Nonnull OperationFinishEvent finishEvent) {
        Object details = buildOperation.getDetails();
        if (details instanceof ExecuteTaskBuildOperationDetails) {
            ExecuteTaskBuildOperationDetails executeTaskDetails = (ExecuteTaskBuildOperationDetails)details;
            String name = executeTaskDetails.getTask().getName();
            if (!SUPPORTED_TASK_NAME.contains(name)) {
                return;
            }
            DockerClientService dockerClientService = (DockerClientService)((Params)this.getParameters()).getDockerClientService().getOrNull();
            if (dockerClientService == null) {
                return;
            }
            File containerIdFile = (File)((Params)this.getParameters()).getContainerId().get();
            if (!containerIdFile.exists()) {
                return;
            }
            String containerId = null;
            try {
                containerId = this.readFirstLine(containerIdFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (StringUtils.isBlank((CharSequence)containerId)) {
                return;
            }
            try (DockerClient dockerClient = this.getDockerClient(dockerClientService);
                 RemoveContainerCmd removeContainerCmd = dockerClient.removeContainerCmd(containerId);){
                removeContainerCmd.withForce(Boolean.valueOf(true)).exec();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    String readFirstLine(File file) throws IOException {
        List<String> lines = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
        return lines.isEmpty() ? null : lines.get(0);
    }

    DockerClient getDockerClient(DockerClientService dockerClientService) {
        return dockerClientService.getDockerClient(this.createDockerClientConfig(dockerClientService));
    }

    private DockerClientConfiguration createDockerClientConfig(DockerClientService dockerClientService) {
        DockerClientService.Params parameters = (DockerClientService.Params)dockerClientService.getParameters();
        DockerClientConfiguration dockerClientConfig = new DockerClientConfiguration();
        dockerClientConfig.setUrl((String)parameters.getUrl().getOrNull());
        dockerClientConfig.setCertPath((Directory)parameters.getCertPath().getOrNull());
        dockerClientConfig.setApiVersion((String)parameters.getApiVersion().getOrNull());
        return dockerClientConfig;
    }

    public static interface Params
    extends BuildServiceParameters {
        public Property<DockerClientService> getDockerClientService();

        public Property<File> getContainerId();
    }
}

