/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.tasks.Jar;
import org.gradle.work.DisableCachingByDefault;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.halo.gradle.Assert;
import run.halo.gradle.FilterComponentClassVisitor;

@DisableCachingByDefault(because="Not worth caching")
public class PluginComponentsIndexTask
extends DefaultTask {
    private static final Logger log = LoggerFactory.getLogger(PluginComponentsIndexTask.class);
    private static final char PACKAGE_SEPARATOR = '.';
    private static final char PATH_SEPARATOR = '/';
    private static final String CLASS_SUFFIX = ".class";
    private static final String FILEPATH = "META-INF/plugin-components.idx";
    public static final String TASK_NAME = "generatePluginComponentsIdx";
    @InputFiles
    ConfigurableFileCollection classesDirs = this.getProject().getObjects().fileCollection();

    @TaskAction
    public void generate() throws IOException {
        log.info("Generating plugin components index file...");
        String buildPath = this.classesDirs.getAsPath();
        LinkedHashSet<String> componentsIdxFileLines = new LinkedHashSet<String>();
        componentsIdxFileLines.add("# Generated by Halo");
        for (File file : this.classesDirs.getAsFileTree()) {
            if (!file.getName().endsWith(CLASS_SUFFIX)) continue;
            ClassReader classReader = new ClassReader((InputStream)new FileInputStream(file));
            FilterComponentClassVisitor filterComponentClassVisitor = new FilterComponentClassVisitor(589824);
            classReader.accept((ClassVisitor)filterComponentClassVisitor, 2);
            if (!filterComponentClassVisitor.isComponentClass()) continue;
            String className = PluginComponentsIndexTask.convertResourcePathToClassName(filterComponentClassVisitor.getName());
            componentsIdxFileLines.add(className);
        }
        Path componentsIdxPath = Paths.get(buildPath, new String[0]).resolve(FILEPATH);
        if (!Files.exists(componentsIdxPath.getParent(), new LinkOption[0])) {
            Files.createDirectories(componentsIdxPath.getParent(), new FileAttribute[0]);
        }
        if (!Files.exists(componentsIdxPath, new LinkOption[0])) {
            Files.createFile(componentsIdxPath, new FileAttribute[0]);
        }
        Files.write(componentsIdxPath, componentsIdxFileLines, StandardCharsets.UTF_8, new OpenOption[0]);
        this.getProject().getTasks().named("jar", Jar.class).configure(jar -> jar.into((Object)"META-INF", copySpec -> copySpec.from(new Object[]{componentsIdxPath})));
    }

    public ConfigurableFileCollection getClassesDirs() {
        return this.classesDirs;
    }

    public static String convertResourcePathToClassName(String resourcePath) {
        Assert.notNull(resourcePath, "Resource path must not be null");
        return resourcePath.replace('/', '.');
    }
}

