/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.jvm.tasks.Jar;
import run.halo.gradle.PluginArchiveSupport;

public class PluginJarManifestCustomizer {
    private static final String DEFAULT_MAIN_CLASS = "run.halo.app.plugin.BasePlugin";
    private final Provider<String> projectName;
    private final Provider<Object> projectVersion;
    private final PluginArchiveSupport support;
    private static final String LIB_DIRECTORY = "lib/";
    Property<JavaVersion> targetJavaVersion;
    final Property<String> mainClass;
    final Project project;
    private FileCollection classpath;

    public PluginJarManifestCustomizer(Project project) {
        this.project = project;
        this.mainClass = project.getObjects().property(String.class);
        this.targetJavaVersion = project.getObjects().property(JavaVersion.class);
        this.support = new PluginArchiveSupport((String)this.mainClass.getOrElse((Object)DEFAULT_MAIN_CLASS));
        this.projectName = project.provider(() -> ((Project)project).getName());
        this.projectVersion = project.provider(() -> ((Project)project).getVersion());
    }

    private void configureJarSpec(Jar jarSpec) {
        jarSpec.from((Object)"lib", PluginJarManifestCustomizer.fromCallTo(this::libArchiveFiles));
    }

    public void configureJarArchiveFilesSpec(Jar jarSpec) {
        jarSpec.into(null, PluginJarManifestCustomizer.fromCallTo(() -> this.libArchiveFiles().stream().map(arg_0 -> ((Project)this.project).zipTree(arg_0)).collect(Collectors.toSet())));
    }

    private List<File> libArchiveFiles() {
        return StreamSupport.stream(this.classpathFiles().spliterator(), false).filter(this.support::isZip).toList();
    }

    public void configureManifest(Manifest manifest) {
        this.support.configureManifest(manifest, LIB_DIRECTORY, ((JavaVersion)this.targetJavaVersion.get()).getMajorVersion(), (String)this.projectName.get(), this.projectVersion.get());
    }

    private Iterable<File> classpathFiles() {
        return this.classpathEntries((Spec<File>)((Spec)File::isFile));
    }

    private Iterable<File> classpathEntries(Spec<File> filter) {
        return this.classpath != null ? this.classpath.filter(filter) : Collections.emptyList();
    }

    public void classpath(Object ... classpath) {
        FileCollection existingClasspath = this.classpath;
        this.classpath = this.getProject().files(new Object[]{existingClasspath != null ? existingClasspath : Collections.emptyList(), classpath});
    }

    public Project getProject() {
        return this.project;
    }

    private static <T> Action<CopySpec> fromCallTo(Callable<T> callable) {
        return spec -> spec.from(new Object[]{PluginJarManifestCustomizer.callTo(callable)});
    }

    private static <T> Callable<T> callTo(Callable<T> callable) {
        return callable;
    }

    public Property<String> getMainClass() {
        return this.mainClass;
    }

    public Property<JavaVersion> getTargetJavaVersion() {
        return this.targetJavaVersion;
    }
}

