/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle;

import java.net.http.HttpClient;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import run.halo.gradle.HaloExtension;
import run.halo.gradle.steps.CreateHttpClientStep;
import run.halo.gradle.steps.ReloadPluginStep;

@DisableCachingByDefault(because="Not worth caching")
public class ReloadPluginTask
extends DefaultTask {
    public static final String TASK_NAME = "reloadPlugin";
    @Input
    private final Property<String> pluginName = this.getProject().getObjects().property(String.class);
    private final ReloadPluginStep reloadPluginStep;

    public ReloadPluginTask() {
        HaloExtension haloExt = (HaloExtension)this.getProject().getExtensions().getByType(HaloExtension.class);
        this.reloadPluginStep = new ReloadPluginStep(haloExt.getExternalUrl(), this.createHttpClient());
    }

    @TaskAction
    public void reloadPlugin() {
        this.reloadPluginStep.execute((String)this.pluginName.get());
    }

    private HttpClient createHttpClient() {
        HaloExtension haloExt = (HaloExtension)this.getProject().getExtensions().getByType(HaloExtension.class);
        String username = haloExt.getSuperAdminUsername();
        String password = haloExt.getSuperAdminPassword();
        return new CreateHttpClientStep(username, password).create();
    }

    public Property<String> getPluginName() {
        return this.pluginName;
    }
}

