/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.docker;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.InspectImageCmd;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.PullResponseItem;
import org.gradle.api.Action;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.halo.gradle.docker.AbstractDockerRemoteApiTask;

public class DockerPullImage
extends AbstractDockerRemoteApiTask {
    private static final Logger log = LoggerFactory.getLogger(DockerPullImage.class);
    @Input
    protected final Property<String> image = this.getProject().getObjects().property(String.class);
    @Input
    @Optional
    final Property<String> platform = this.getProject().getObjects().property(String.class);

    @Override
    public void runRemoteCommand() {
        log.info("Pulling image '{}'.", this.image.get());
        if (this.checkImageExits()) {
            log.info("Image [{}] already exists, skipping pull.", this.image.get());
            return;
        }
        try (PullImageCmd pullImageCmd = this.getDockerClient().pullImageCmd((String)this.image.get());){
            if (this.platform.getOrNull() != null) {
                pullImageCmd.withPlatform((String)this.platform.get());
            }
            PullImageResultCallback callback = this.createCallback(this.getNextHandler());
            ((PullImageResultCallback)pullImageCmd.exec((ResultCallback)callback)).awaitCompletion();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkImageExits() {
        try (InspectImageCmd inspectImageCmd = this.getDockerClient().inspectImageCmd((String)this.image.get());){
            InspectImageResponse response = inspectImageCmd.exec();
            if (response == null) return false;
            boolean bl = true;
            return bl;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return false;
    }

    private PullImageResultCallback createCallback(final Action<? super Object> nextHandler) {
        return new PullImageResultCallback(){

            public void onNext(PullResponseItem item) {
                if (nextHandler != null) {
                    try {
                        nextHandler.execute((Object)item);
                    }
                    catch (Exception e) {
                        log.error("Failed to handle pull response [{}]", (Object)e.getMessage(), (Object)e);
                        return;
                    }
                }
                super.onNext(item);
            }
        };
    }

    public Property<String> getImage() {
        return this.image;
    }

    public Property<String> getPlatform() {
        return this.platform;
    }
}

