/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.docker;

import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.StreamType;
import com.google.common.base.Charsets;

public class OutputFrame {
    public static final OutputFrame END = new OutputFrame(OutputType.END, null);
    private final OutputType type;
    private final byte[] bytes;

    public OutputFrame(OutputType type, byte[] bytes) {
        this.type = type;
        this.bytes = bytes;
    }

    public OutputType getType() {
        return this.type;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getUtf8String() {
        if (this.bytes == null) {
            return "";
        }
        return new String(this.bytes, Charsets.UTF_8);
    }

    public static OutputFrame forFrame(Frame frame) {
        OutputType outputType = OutputType.forStreamType(frame.getStreamType());
        if (outputType == null) {
            return null;
        }
        return new OutputFrame(outputType, frame.getPayload());
    }

    public static enum OutputType {
        STDOUT,
        STDERR,
        END;


        public static OutputType forStreamType(StreamType streamType) {
            return switch (streamType) {
                case StreamType.RAW, StreamType.STDOUT -> STDOUT;
                case StreamType.STDERR -> STDERR;
                default -> null;
            };
        }
    }
}

