/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.steps;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.halo.gradle.Assert;
import run.halo.gradle.RetryUtils;
import run.halo.gradle.YamlUtils;
import run.halo.gradle.model.ObjectNodeListResult;

public class InitializeHaloStep {
    private static final Logger log = LoggerFactory.getLogger(InitializeHaloStep.class);
    private final HttpClient client;
    private final String host;

    public InitializeHaloStep(String host, HttpClient client) {
        Assert.notNull(host, "host must not be null");
        Assert.notNull(client, "httpClient must not be null");
        this.host = StringUtils.defaultString((String)host, (String)"http://localhost:8090");
        this.client = client;
    }

    public void execute() {
        this.waitForReadiness(this.client);
        try {
            this.initializeHalo(this.client);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void waitForReadiness(HttpClient client) {
        HttpRequest request = HttpRequest.newBuilder().uri(this.buildUri("/actuator/health")).GET().build();
        RetryUtils.withRetry(20, 400L, () -> {
            try {
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                return this.isSuccessful(response);
            }
            catch (Exception e) {
                return false;
            }
        });
    }

    private URI buildUri(String endpoint) {
        String path = StringUtils.prependIfMissing((String)endpoint, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        String hostPrepared = StringUtils.removeEnd((String)this.host, (String)"/");
        try {
            return new URI(hostPrepared + path);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isSuccessful(HttpResponse<String> response) {
        return response.statusCode() >= 200 && response.statusCode() < 300;
    }

    private void initializeHalo(HttpClient client) throws IOException, InterruptedException {
        HttpRequest checkSystemStates = HttpRequest.newBuilder().uri(this.buildUri("/api/v1alpha1/configmaps/system-states")).GET().build();
        HttpResponse<String> checkResponse = client.send(checkSystemStates, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        if (this.isSuccessful(checkResponse)) {
            return;
        }
        HttpRequest createSystemStateConfig = HttpRequest.newBuilder().uri(this.buildUri("/api/v1alpha1/configmaps")).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString("{\n    \"data\": {\n        \"states\": \"{\\\"isSetup\\\":true}\"\n    },\n    \"apiVersion\": \"v1alpha1\",\n    \"kind\": \"ConfigMap\",\n    \"metadata\": {\n        \"name\": \"system-states\"\n    }\n}\n")).build();
        HttpResponse<String> createResponse = client.send(createSystemStateConfig, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        if (!this.isSuccessful(createResponse)) {
            throw new RuntimeException(createResponse.body());
        }
        this.createMenu(client);
    }

    private void initializeTheme(HttpClient client) throws URISyntaxException, IOException, InterruptedException {
        HttpRequest listUninstalledTheme = HttpRequest.newBuilder().uri(this.buildUri("/apis/api.console.halo.run/v1alpha1/themes?uninstalled=true")).GET().build();
        HttpResponse<String> listUninstalledThemResp = client.send(listUninstalledTheme, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        if (!this.isSuccessful(listUninstalledThemResp)) {
            throw new RuntimeException(listUninstalledThemResp.body());
        }
        String body = listUninstalledThemResp.body();
        ObjectNodeListResult listResult = (ObjectNodeListResult)YamlUtils.mapper.readValue(body, ObjectNodeListResult.class);
        if (listResult == null || listResult.getItems().isEmpty()) {
            return;
        }
        ObjectNode item = (ObjectNode)listResult.getItems().get(0);
        this.createTheme(client, item.toString());
    }

    private void createTheme(HttpClient client, String payload) throws URISyntaxException, IOException, InterruptedException {
        HttpRequest installRequest = HttpRequest.newBuilder().uri(this.buildUri("/apis/theme.halo.run/v1alpha1/themes")).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(payload)).build();
        HttpResponse<String> response = client.send(installRequest, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        if (!this.isSuccessful(response)) {
            throw new RuntimeException(response.body());
        }
        String body = response.body();
        ObjectNode theme = (ObjectNode)YamlUtils.mapper.readValue(body, ObjectNode.class);
        JsonNode nameNode = theme.at("/metadata/name");
        if (nameNode == null) {
            throw new IllegalStateException("Unexpected theme name from [" + theme + "]");
        }
        HttpRequest reloadSettingReq = HttpRequest.newBuilder().uri(this.buildUri("/apis/api.console.halo.run/v1alpha1/themes/" + nameNode.asText() + "/reload")).PUT(HttpRequest.BodyPublishers.noBody()).build();
        HttpResponse<String> reloadResponse = client.send(reloadSettingReq, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        if (!this.isSuccessful(reloadResponse)) {
            throw new IllegalStateException("Reload theme setting failed: " + reloadResponse.body());
        }
    }

    private void createMenu(HttpClient client) throws IOException, InterruptedException {
        UUID menuItemUid = UUID.randomUUID();
        HttpRequest installRequest = HttpRequest.newBuilder().uri(this.buildUri("/api/v1alpha1/menus")).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString("{\n    \"spec\": {\n        \"displayName\": \"\u9ed8\u8ba4\",\n        \"menuItems\": [\"%s\"]\n    },\n    \"apiVersion\": \"v1alpha1\",\n    \"kind\": \"Menu\",\n    \"metadata\": {\n        \"name\": \"\",\n        \"generateName\": \"menu-\"\n    }\n}\n".formatted(menuItemUid))).build();
        HttpResponse<String> response = client.send(installRequest, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        if (!this.isSuccessful(response)) {
            throw new RuntimeException(response.body());
        }
        HttpRequest createMenuItem = HttpRequest.newBuilder().uri(this.buildUri("/api/v1alpha1/menuitems")).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString("{\n    \"spec\": {\n        \"displayName\": \"\u9996\u9875\",\n        \"href\": \"/index\",\n        \"children\": [],\n        \"priority\": 0\n    },\n    \"apiVersion\": \"v1alpha1\",\n    \"kind\": \"MenuItem\",\n    \"metadata\": {\n        \"name\": \"%s\"\n    }\n}\n".formatted(menuItemUid))).build();
        HttpResponse<String> menuItemResponse = client.send(createMenuItem, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        if (!this.isSuccessful(menuItemResponse)) {
            throw new RuntimeException(menuItemResponse.body());
        }
    }
}

