/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.watch;

import java.io.File;
import java.io.IOException;
import java.net.http.HttpClient;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.gradle.StartParameter;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.pattern.PatternMatcher;
import org.gradle.api.internal.file.pattern.PatternMatcherFactory;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.halo.gradle.HaloExtension;
import run.halo.gradle.HaloPluginExtension;
import run.halo.gradle.WatchExecutionParameters;
import run.halo.gradle.docker.DockerStartContainer;
import run.halo.gradle.steps.CreateHttpClientStep;
import run.halo.gradle.steps.InitializeHaloStep;
import run.halo.gradle.steps.ReloadPluginStep;
import run.halo.gradle.watch.FileMatchingFilter;
import run.halo.gradle.watch.FileSystemWatcher;
import run.halo.gradle.watch.SnapshotStateRepository;
import run.halo.gradle.watch.WatchTarget;
import run.halo.gradle.watch.WatchTaskRunner;

public class WatchTask
extends DockerStartContainer {
    private static final Logger log = LoggerFactory.getLogger(WatchTask.class);
    private final HaloPluginExtension pluginExtension = (HaloPluginExtension)this.getProject().getExtensions().getByType(HaloPluginExtension.class);
    private final HaloExtension haloExtension = (HaloExtension)this.getProject().getExtensions().getByType(HaloExtension.class);
    final HttpClient httpClient = this.createHttpClient();

    WatchExecutionParameters getParameters(List<String> buildArgs) {
        return WatchExecutionParameters.builder().projectDir(this.getProject().getProjectDir()).buildArgs(buildArgs).environment(System.getenv()).build();
    }

    private ClassPath getInjectedClassPath() {
        StartParameter parameter = this.getProject().getGradle().getStartParameter();
        String classpath = (String)parameter.getProjectProperties().get("classpath");
        if (classpath != null) {
            List<File> files = Arrays.stream(classpath.split(", ")).map(File::new).toList();
            return DefaultClassPath.of(files);
        }
        return null;
    }

    private List<String> getBuildArgs() {
        StartParameter parameter = this.getProject().getGradle().getStartParameter();
        return this.getArguments(parameter);
    }

    private List<String> getArguments(StartParameter parameter) {
        ArrayList<String> args = new ArrayList<String>();
        for (Map.Entry e : parameter.getProjectProperties().entrySet()) {
            args.add("-P" + (String)e.getKey() + "=" + (String)e.getValue());
        }
        return args;
    }

    @Override
    public void runRemoteCommand() {
        Duration pollInterval = Duration.ofSeconds(2L);
        Duration quietPeriod = Duration.ofMillis(500L);
        FileSystemWatcher watcher = new FileSystemWatcher(false, pollInterval, quietPeriod, SnapshotStateRepository.STATIC);
        this.configWatchFiles(watcher);
        String host = this.haloExtension.getExternalUrl();
        ReloadPluginStep reloadPluginStep = new ReloadPluginStep(host, this.httpClient);
        System.out.println("\u8fd0\u884c........");
        CompletableFuture<Void> initializeFuture = CompletableFuture.runAsync(() -> {
            new InitializeHaloStep(host, this.httpClient).execute();
            reloadPluginStep.execute(this.getPluginName());
        });
        initializeFuture.exceptionally(e -> {
            e.printStackTrace();
            return null;
        });
        WatchExecutionParameters parameters = this.getParameters(List.of("build"));
        try (WatchTaskRunner runner = new WatchTaskRunner(this.getProject());){
            watcher.addListener(changeSet -> {
                System.out.println("File changed......" + changeSet);
                runner.run(parameters);
                reloadPluginStep.execute(this.getPluginName());
            });
            watcher.start();
            super.runRemoteCommand();
        }
    }

    private void configWatchFiles(FileSystemWatcher watcher) {
        ArrayList<WatchTarget> watchTargets = new ArrayList<WatchTarget>((Collection<WatchTarget>)this.pluginExtension.getWatchDomains());
        HashSet<File> watchFiles = new HashSet<File>();
        HashSet<String> excludes = new HashSet<String>();
        WatchTarget javaSourceTarget = new WatchTarget("javaSource");
        javaSourceTarget.files((FileCollection)this.getProject().files(new Object[]{"src/main/"}));
        watchTargets.add(javaSourceTarget);
        for (WatchTarget watchTarget : watchTargets) {
            Set files = watchTarget.getFiles().stream().map(FileCollection::getFiles).flatMap(Collection::stream).filter(File::isDirectory).collect(Collectors.toSet());
            watchFiles.addAll(files);
            excludes.addAll(watchTarget.getExcludes());
        }
        this.populateDefaultExcludeRules(excludes);
        log.info("Excludes files to watching: {}", excludes);
        PatternMatcher patternsMatcher = PatternMatcherFactory.getPatternsMatcher((boolean)false, (boolean)true, excludes);
        watcher.setExcludeFileFilter(new FileMatchingFilter(patternsMatcher));
        log.info("Watching files: {}", watchFiles);
        watcher.addSourceDirectories(watchFiles);
    }

    private void populateDefaultExcludeRules(Set<String> excludes) {
        if (excludes == null) {
            return;
        }
        excludes.add("**/node_modules/**");
        excludes.add("**/.idea/**");
        excludes.add("**/.git/**");
        excludes.add("**/.gradle/**");
        excludes.add(this.excludePattern("src/main/resources/console/**"));
        excludes.add(this.excludePattern("build/**"));
        excludes.add(this.excludePattern("gradle/**"));
        excludes.add(this.excludePattern("dist/**"));
        excludes.add(this.excludePattern("test/java/**"));
        excludes.add(this.excludePattern("test/resources/**"));
    }

    String excludePattern(String pattern) {
        Path projectPath = this.getProject().getProjectDir().toPath();
        return projectPath.resolve(StringUtils.removeStart((String)pattern, (String)"/")).toString();
    }

    private File getPluginBuildFile() {
        File file;
        block8: {
            Path buildLibPath = this.getProject().getBuildDir().toPath().resolve("libs");
            Stream<Path> pathStream = Files.find(buildLibPath, 1, (path, basicFileAttributes) -> {
                String fileName = path.getFileName().toString();
                return fileName.endsWith(".jar");
            }, new FileVisitOption[0]);
            try {
                file = pathStream.findFirst().orElseThrow(() -> new IllegalStateException("\u672a\u627e\u5230\u63d2\u4ef6jar\u5305")).toFile();
                if (pathStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("\u672a\u627e\u5230\u63d2\u4ef6jar\u5305", e);
                }
            }
            pathStream.close();
        }
        return file;
    }

    private HttpClient createHttpClient() {
        String username = this.haloExtension.getSuperAdminUsername();
        String password = this.haloExtension.getSuperAdminPassword();
        return new CreateHttpClientStep(username, password).create();
    }

    private String getPluginName() {
        return this.pluginExtension.getPluginName();
    }
}

