/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.File;
import java.io.IOException;
import java.util.function.Function;

public class YamlUtils {
    public static final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public static <T> T read(File yamlSource, Class<T> clazz) {
        try {
            return (T)mapper.readValue(yamlSource, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(File yamlSource, Function<JsonNode, JsonNode> transform, File target) {
        try {
            JsonNode jsonNode = mapper.readTree(yamlSource);
            JsonNode root = transform.apply(jsonNode);
            mapper.writer().writeValue(target, (Object)root);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mapper.registerModule((Module)new JavaTimeModule());
    }
}

