/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.docker;

import com.github.dockerjava.api.command.CopyArchiveToContainerCmd;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.halo.gradle.Assert;
import run.halo.gradle.docker.DockerExistingContainer;

public class DockerCopyFileToContainer
extends DockerExistingContainer {
    private static final Logger log = LoggerFactory.getLogger(DockerCopyFileToContainer.class);
    @Input
    @Optional
    final Property<String> remotePath = this.getProject().getObjects().property(String.class);
    @Input
    @Optional
    final Property<String> hostPath = this.getProject().getObjects().property(String.class);
    @Input
    @Optional
    final RegularFileProperty tarFile = this.getProject().getObjects().fileProperty();
    @Input
    @Optional
    final List<CopyFileToContainer> copyFiles = new ArrayList<CopyFileToContainer>();
    private final FileOperations fileOperations = ((ProjectInternal)this.getProject()).getFileOperations();

    @Override
    public void runRemoteCommand() {
        if (this.remotePath.getOrNull() != null) {
            if (this.hostPath.getOrNull() != null && this.tarFile.getOrNull() != null) {
                throw new GradleException("Can specify either hostPath or tarFile not both");
            }
            if (this.hostPath.getOrNull() != null) {
                this.withFile((String)this.hostPath.get(), (String)this.remotePath.get());
            } else if (this.tarFile.getOrNull() != null) {
                this.withTarFile((RegularFile)this.tarFile.get(), (String)this.remotePath.get());
            }
        }
        for (CopyFileToContainer fileToCopy : this.copyFiles) {
            log.debug("Copying file to container with ID [{}] at [{}].", this.containerId.get(), fileToCopy.getRemotePath());
            CopyArchiveToContainerCmd containerCommand = this.getDockerClient().copyArchiveToContainerCmd((String)this.containerId.get());
            this.setContainerCommandConfig(containerCommand, fileToCopy);
            containerCommand.exec();
        }
    }

    private void setContainerCommandConfig(CopyArchiveToContainerCmd containerCommand, CopyFileToContainer copyFileToContainer) {
        File localHostPath = this.fileOperations.file(copyFileToContainer.hostPath);
        containerCommand.withRemotePath(copyFileToContainer.remotePath.toString());
        if (copyFileToContainer.isTar()) {
            try {
                containerCommand.withTarInputStream((InputStream)new FileInputStream(localHostPath));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        } else {
            containerCommand.withHostResource(localHostPath.getPath());
        }
    }

    void withFile(String hostPath, String remotePath) {
        Assert.notNull(hostPath, "hostPath cannot be null");
        Assert.notNull(remotePath, "remotePath cannot be null");
        CopyFileToContainer copyFileToContainer = new CopyFileToContainer();
        copyFileToContainer.setHostPath(hostPath);
        copyFileToContainer.setRemotePath(remotePath);
        this.copyFiles.add(copyFileToContainer);
    }

    void withTarFile(RegularFile hostPath, String remotePath) {
        Assert.notNull(hostPath, "hostPath cannot be null");
        Assert.notNull(remotePath, "remotePath cannot be null");
        CopyFileToContainer copyFileToContainer = new CopyFileToContainer();
        copyFileToContainer.setHostPath(hostPath);
        copyFileToContainer.setRemotePath(remotePath);
        copyFileToContainer.setTar(true);
        this.copyFiles.add(copyFileToContainer);
    }

    public Property<String> getRemotePath() {
        return this.remotePath;
    }

    public Property<String> getHostPath() {
        return this.hostPath;
    }

    public List<CopyFileToContainer> getCopyFiles() {
        return this.copyFiles;
    }

    public RegularFileProperty getTarFile() {
        return this.tarFile;
    }

    public static class CopyFileToContainer {
        @Input
        private Object hostPath;
        @Input
        private Object remotePath;
        @Internal
        private boolean isTar = false;

        public Object getHostPath() {
            return this.hostPath;
        }

        public Object getRemotePath() {
            return this.remotePath;
        }

        public boolean isTar() {
            return this.isTar;
        }

        public void setHostPath(Object hostPath) {
            this.hostPath = hostPath;
        }

        public void setRemotePath(Object remotePath) {
            this.remotePath = remotePath;
        }

        public void setTar(boolean isTar) {
            this.isTar = isTar;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CopyFileToContainer)) {
                return false;
            }
            CopyFileToContainer other = (CopyFileToContainer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isTar() != other.isTar()) {
                return false;
            }
            Object this$hostPath = this.getHostPath();
            Object other$hostPath = other.getHostPath();
            if (this$hostPath == null ? other$hostPath != null : !this$hostPath.equals(other$hostPath)) {
                return false;
            }
            Object this$remotePath = this.getRemotePath();
            Object other$remotePath = other.getRemotePath();
            return !(this$remotePath == null ? other$remotePath != null : !this$remotePath.equals(other$remotePath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CopyFileToContainer;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isTar() ? 79 : 97);
            Object $hostPath = this.getHostPath();
            result = result * 59 + ($hostPath == null ? 43 : $hostPath.hashCode());
            Object $remotePath = this.getRemotePath();
            result = result * 59 + ($remotePath == null ? 43 : $remotePath.hashCode());
            return result;
        }

        public String toString() {
            return "DockerCopyFileToContainer.CopyFileToContainer(hostPath=" + this.getHostPath() + ", remotePath=" + this.getRemotePath() + ", isTar=" + this.isTar() + ")";
        }
    }
}

