/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.docker;

import com.github.dockerjava.api.command.RemoveContainerCmd;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.halo.gradle.docker.CheckContainerExistsStep;
import run.halo.gradle.docker.DockerExistingContainer;

public class DockerRemoveContainer
extends DockerExistingContainer {
    private static final Logger log = LoggerFactory.getLogger(DockerRemoveContainer.class);
    @Input
    @Optional
    final Property<Boolean> force = this.getProject().getObjects().property(Boolean.class);
    @Input
    @Optional
    final Property<Integer> waitTime = this.getProject().getObjects().property(Integer.class);

    @Override
    public void runRemoteCommand() {
        String id = (String)this.getContainerId().get();
        boolean exists = new CheckContainerExistsStep(this.getDockerClient(), id).execute();
        if (!exists) {
            return;
        }
        RemoveContainerCmd containerCommand = this.getDockerClient().removeContainerCmd(id);
        this.configureContainerCommandConfig(containerCommand);
        log.info("Removing container with ID [{}].", (Object)id);
        containerCommand.withForce(Boolean.valueOf(true)).exec();
    }

    private void configureContainerCommandConfig(RemoveContainerCmd containerCommand) {
        if (this.force.getOrNull() != null) {
            containerCommand.withForce((Boolean)this.force.get());
        }
    }

    public Property<Boolean> getForce() {
        return this.force;
    }

    public Property<Integer> getWaitTime() {
        return this.waitTime;
    }
}

