/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.steps;

import java.util.ArrayList;
import java.util.Base64;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.message.BasicHeader;
import run.halo.gradle.Assert;
import run.halo.gradle.steps.HaloSiteOption;

public class HttpClientFactory {
    private final HaloSiteOption haloSiteOption;

    public HttpClientFactory(HaloSiteOption haloSiteOption) {
        Assert.notNull(haloSiteOption, "haloSiteOption must not be null");
        this.haloSiteOption = haloSiteOption;
    }

    public CloseableHttpClient create() {
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        headers.add(new BasicHeader("Authorization", (Object)HttpClientFactory.getBasicAuthenticationHeader(this.haloSiteOption)));
        return HttpClients.custom().setDefaultHeaders(headers).build();
    }

    private static String getBasicAuthenticationHeader(HaloSiteOption haloSiteOption) {
        String valueToEncode = haloSiteOption.username() + ":" + haloSiteOption.password();
        return "Basic " + Base64.getEncoder().encodeToString(valueToEncode.getBytes());
    }
}

