/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.steps;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.URI;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.halo.gradle.Assert;
import run.halo.gradle.RetryUtils;
import run.halo.gradle.YamlUtils;
import run.halo.gradle.steps.HaloSiteOption;

public class InitializeHaloStep {
    private static final Logger log = LoggerFactory.getLogger(InitializeHaloStep.class);
    private final HaloSiteOption haloSiteOption;

    public InitializeHaloStep(HaloSiteOption haloSiteOption) {
        Assert.notNull(haloSiteOption, "haloSiteOption must not be null");
        this.haloSiteOption = haloSiteOption;
    }

    public void execute() {
        try (CloseableHttpClient client = HttpClients.createDefault();){
            this.waitForReadiness(client);
            this.initializeUserAccount(client);
            System.out.println("Halo \u521d\u59cb\u5316\u6210\u529f\uff0c\u8bbf\u95ee\uff1a " + this.requestUri("/console") + "\n\u7528\u6237\u540d\uff1a" + this.haloSiteOption.username() + "\n\u5bc6\u7801\uff1a" + this.haloSiteOption.password() + "\n");
        }
        catch (IOException | ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private void waitForReadiness(CloseableHttpClient client) {
        HttpGet httpGet = new HttpGet(this.requestUri("/actuator/health"));
        RetryUtils.withRetry(20, 400L, () -> {
            try {
                CloseableHttpResponse response = client.execute((ClassicHttpRequest)httpGet);
                return InitializeHaloStep.isSuccessful(response);
            }
            catch (Exception e) {
                return false;
            }
        });
    }

    URI requestUri(String path) {
        return this.haloSiteOption.externalUrl().resolve(path);
    }

    private static boolean isSuccessful(CloseableHttpResponse response) {
        return response.getCode() >= 200 && response.getCode() < 300;
    }

    private void initializeUserAccount(CloseableHttpClient client) throws IOException, ParseException {
        HttpGet globalInfoHttpGet = new HttpGet(this.requestUri("/actuator/globalinfo"));
        CloseableHttpResponse globalInfoResp = client.execute((ClassicHttpRequest)globalInfoHttpGet);
        JsonNode globalInfo = (JsonNode)YamlUtils.mapper.convertValue((Object)EntityUtils.toString((HttpEntity)globalInfoResp.getEntity()), JsonNode.class);
        JsonNode userInitialized = globalInfo.get("userInitialized");
        if (userInitialized != null && userInitialized.asBoolean()) {
            return;
        }
        HttpPost initializeRequest = this.getInitializeRequest();
        CloseableHttpResponse response = client.execute((ClassicHttpRequest)initializeRequest);
        if (InitializeHaloStep.isSuccessful(response)) {
            log.info("Initialize system successfully.");
        } else {
            log.error("Initialize system failed: {}", (Object)EntityUtils.toString((HttpEntity)response.getEntity()));
        }
    }

    private HttpPost getInitializeRequest() {
        HttpPost initializeRequest = new HttpPost(this.requestUri("/apis/api.console.halo.run/v1alpha1/system/initialize"));
        StringEntity entity = new StringEntity("{\n    \"siteTitle\": \"Halo\",\n    \"username\": \"%s\",\n    \"password\": \"%s\",\n    \"email\": \"admin@halo.run\"\n}\n".formatted(this.haloSiteOption.username(), this.haloSiteOption.password()), ContentType.APPLICATION_JSON);
        initializeRequest.setEntity((HttpEntity)entity);
        return initializeRequest;
    }
}

