/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle;

import java.util.concurrent.CompletableFuture;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.halo.gradle.docker.DockerStartContainer;
import run.halo.gradle.extension.HaloExtension;
import run.halo.gradle.steps.HaloSiteOption;
import run.halo.gradle.steps.SetupHaloStep;

public class HaloServerTask
extends DockerStartContainer {
    private static final Logger log = LoggerFactory.getLogger(HaloServerTask.class);
    public static final String TASK_NAME = "haloServer";
    private final HaloExtension haloExtension = (HaloExtension)this.getProject().getExtensions().getByType(HaloExtension.class);

    @Override
    @TaskAction
    public void runRemoteCommand() {
        HaloSiteOption haloSiteOption = HaloSiteOption.from(this.haloExtension);
        CompletableFuture<Void> initializeFuture = CompletableFuture.runAsync(() -> new SetupHaloStep(haloSiteOption).execute());
        initializeFuture.exceptionally(e -> {
            log.error(e.getMessage(), e);
            return null;
        });
        super.runRemoteCommand();
    }
}

