/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.docker;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerCmd;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Volume;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.halo.gradle.docker.DockerExistingImage;
import run.halo.gradle.extension.HaloExtension;
import run.halo.gradle.extension.HaloPluginExtension;
import run.halo.gradle.utils.HaloServerConfigure;
import run.halo.gradle.utils.YamlUtils;

public class DockerCreateContainer
extends DockerExistingImage {
    private static final Logger log = LoggerFactory.getLogger(DockerCreateContainer.class);
    private final HaloPluginExtension pluginExtension = (HaloPluginExtension)this.getProject().getExtensions().getByType(HaloPluginExtension.class);
    private final HaloExtension haloExtension = (HaloExtension)this.getProject().getExtensions().getByType(HaloExtension.class);
    @Input
    @Optional
    final Property<String> containerName = this.getProject().getObjects().property(String.class);
    @Optional
    @InputDirectory
    final DirectoryProperty pluginWorkplaceDir = this.getProject().getObjects().directoryProperty();
    @InputFile
    @Optional
    final RegularFileProperty additionalApplicationConfig = this.getProject().getObjects().fileProperty();
    @OutputFile
    final RegularFileProperty containerIdFile = this.getProject().getObjects().fileProperty();
    @Internal
    final Property<String> containerId = this.getProject().getObjects().property(String.class);
    @Input
    @Optional
    final Property<String> platform = this.getProject().getObjects().property(String.class);

    public DockerCreateContainer() {
        this.containerId.convention(this.containerIdFile.map((Transformer)new RegularFileToStringTransformer()));
        this.additionalApplicationConfig.convention(this.getProject().provider(() -> {
            RegularFile file = (RegularFile)this.pluginWorkplaceDir.file("config/application.yaml").get();
            return file.getAsFile().exists() ? file : null;
        }));
        String safeTaskPath = this.getPath().replaceFirst("^:", "").replaceAll(":", "_");
        this.containerIdFile.convention(this.getProject().getLayout().getBuildDirectory().file(".docker/" + safeTaskPath + "-containerId.txt"));
        this.getOutputs().upToDateWhen(this.getUpToDateWhenSpec());
    }

    private Spec<Task> getUpToDateWhenSpec() {
        return element -> {
            File file = ((RegularFile)this.getContainerIdFile().get()).getAsFile();
            if (file.exists()) {
                try {
                    String fileContainerId;
                    try {
                        fileContainerId = Files.readString(file.toPath());
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    try (InspectContainerCmd inspectContainerCmd = this.getDockerClient().inspectContainerCmd(fileContainerId);){
                        inspectContainerCmd.exec();
                    }
                    return true;
                }
                catch (DockerException dockerException) {
                    // empty catch block
                }
            }
            return false;
        };
    }

    @Override
    public void runRemoteCommand() {
        String imageId = (String)this.getImageId().get();
        try (CreateContainerCmd containerCommand = this.getDockerClient().createContainerCmd(imageId);){
            this.setContainerCommandConfig(containerCommand);
            CreateContainerResponse container = containerCommand.exec();
            String localContainerName = this.containerName.getOrNull() == null ? container.getId() : (String)this.containerName.get();
            log.info("Created container with ID [{}]", (Object)localContainerName);
            Files.writeString(((RegularFile)this.containerIdFile.get()).getAsFile().toPath(), (CharSequence)container.getId(), new OpenOption[0]);
            Action<? super Object> nextHandler = this.getNextHandler();
            if (nextHandler != null) {
                nextHandler.execute((Object)container);
            }
        }
        catch (Exception e) {
            throw new GradleException("Failed to create container", (Throwable)e);
        }
    }

    private void setContainerCommandConfig(CreateContainerCmd containerCommand) {
        File pluginConfigYaml;
        if (this.containerName.getOrNull() != null) {
            containerCommand.withName((String)this.containerName.get());
        }
        if (this.platform.getOrNull() != null) {
            containerCommand.withPlatform((String)this.platform.get());
        }
        containerCommand.withCmd(new String[]{"--rm"});
        String pluginName = this.pluginExtension.getPluginName();
        Integer port = this.haloExtension.getPort();
        ArrayList<Object> envs = new ArrayList<Object>();
        String applicationJson = HaloServerConfigure.builder().port(port).externalUrl(this.haloExtension.getExternalUrl()).workDir(this.haloWorkDir()).fixedPluginPath(HaloServerConfigure.buildPluginDestPath(pluginName)).build().mergeWithUserConfigAsJson(this.readExternalConfig());
        envs.add("SPRING_APPLICATION_JSON=" + applicationJson);
        boolean isDebugMode = this.isDebugMode();
        int debugPort = this.getDebugPort();
        if (isDebugMode) {
            String suspend = this.haloExtension.getSuspend() != false ? "y" : "n";
            envs.add("JAVA_TOOL_OPTIONS=-agentlib:jdwp=transport=dt_socket,server=y,suspend=%s,address=*:%s".formatted(suspend, debugPort));
        }
        containerCommand.withEnv(envs);
        containerCommand.withImage((String)this.getImageId().get());
        containerCommand.withLabels(Map.of("halo.container.createdBy", "halo-gradle-plugin"));
        ArrayList<ExposedPort> exposedPorts = new ArrayList<ExposedPort>(2);
        exposedPorts.add(ExposedPort.parse((String)String.valueOf(port)));
        if (isDebugMode) {
            exposedPorts.add(ExposedPort.tcp((int)debugPort));
        }
        containerCommand.withExposedPorts(exposedPorts);
        ArrayList<PortBinding> portBindings = new ArrayList<PortBinding>(2);
        portBindings.add(PortBinding.parse((String)"%s:%s".formatted(port, port)));
        if (isDebugMode) {
            portBindings.add(PortBinding.parse((String)(debugPort + ":" + debugPort)));
        }
        HostConfig hostConfig = new HostConfig();
        hostConfig.withPortBindings(portBindings);
        File projectDir = (File)this.getProject().getLayout().getBuildDirectory().getAsFile().get();
        ArrayList<Bind> binds = new ArrayList<Bind>();
        binds.add(new Bind(projectDir.toString(), new Volume(HaloServerConfigure.buildPluginDestPath(pluginName) + "build")));
        if (this.pluginWorkplaceDir.isPresent()) {
            String sourceDir = ((File)this.pluginWorkplaceDir.getAsFile().get()).getAbsolutePath();
            binds.add(new Bind(sourceDir, new Volume(this.haloWorkDir())));
        }
        if ((pluginConfigYaml = (File)this.pluginExtension.getConfigurationPropertiesFile().getAsFile().getOrNull()) != null && Files.exists(pluginConfigYaml.toPath(), new LinkOption[0])) {
            binds.add(new Bind(pluginConfigYaml.getAbsolutePath(), new Volume(HaloServerConfigure.buildPluginConfigYamlPath(this.haloExtension.getServerWorkDir(), pluginName))));
        }
        hostConfig.withBinds(binds);
        containerCommand.withHostConfig(hostConfig);
    }

    @Nonnull
    JsonNode readExternalConfig() {
        if (!this.additionalApplicationConfig.isPresent()) {
            return JsonNodeFactory.instance.missingNode();
        }
        System.out.println(((File)this.additionalApplicationConfig.getAsFile().get()).toPath());
        File additionalFile = (File)this.additionalApplicationConfig.getAsFile().get();
        if (Files.exists(additionalFile.toPath(), new LinkOption[0])) {
            return YamlUtils.read(additionalFile, JsonNode.class);
        }
        return JsonNodeFactory.instance.missingNode();
    }

    String haloWorkDir() {
        return this.haloExtension.getServerWorkDir();
    }

    @Internal
    boolean isDebugMode() {
        return this.jvmDebugPort() != null || this.haloExtension.getDebug() != false;
    }

    @Internal
    int getDebugPort() {
        Integer jvmDebugPort = this.jvmDebugPort();
        if (jvmDebugPort != null) {
            return jvmDebugPort;
        }
        return this.haloExtension.getDebugPort();
    }

    @Nullable
    private Integer jvmDebugPort() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> inputArguments = runtimeMXBean.getInputArguments();
        return inputArguments.stream().filter(argument -> argument.startsWith("-agentlib:jdwp=")).findFirst().map(this::parsePort).orElse(null);
    }

    Integer parsePort(String debugOption) {
        Pattern pattern = Pattern.compile("address=.*:(\\d{1,5})$");
        Matcher matcher = pattern.matcher(debugOption);
        if (matcher.find()) {
            String port = matcher.group(1);
            return Integer.parseInt(port);
        }
        return null;
    }

    public Property<String> getContainerName() {
        return this.containerName;
    }

    public DirectoryProperty getPluginWorkplaceDir() {
        return this.pluginWorkplaceDir;
    }

    public RegularFileProperty getAdditionalApplicationConfig() {
        return this.additionalApplicationConfig;
    }

    public RegularFileProperty getContainerIdFile() {
        return this.containerIdFile;
    }

    public Property<String> getContainerId() {
        return this.containerId;
    }

    public Property<String> getPlatform() {
        return this.platform;
    }

    public static class RegularFileToStringTransformer
    implements Transformer<String, RegularFile>,
    Serializable {
        @Nonnull
        public String transform(RegularFile it) {
            File file = it.getAsFile();
            if (file.exists()) {
                try {
                    return Files.readString(file.toPath());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return "";
        }
    }
}

