/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.docker;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.halo.gradle.docker.BaseConsumer;
import run.halo.gradle.docker.FrameConsumerResultCallback;
import run.halo.gradle.docker.OutputFrame;

public class ToStringConsumer
extends BaseConsumer<ToStringConsumer> {
    private static final Logger log = LoggerFactory.getLogger(ToStringConsumer.class);

    @Override
    public void accept(OutputFrame outputFrame) {
        OutputFrame.OutputType outputType = outputFrame.getType();
        String utf8String = outputFrame.getUtf8String();
        utf8String = FrameConsumerResultCallback.LINE_BREAK_AT_END_PATTERN.matcher(utf8String).replaceAll("");
        switch (outputType) {
            case END: {
                break;
            }
            case STDOUT: {
                System.out.println(utf8String);
                break;
            }
            case STDERR: {
                System.out.println("\u001b[31;m" + utf8String + "\u001b[0m");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected outputType " + outputType);
            }
        }
    }
}

