/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.extension;

import java.io.File;
import java.nio.file.Path;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import run.halo.gradle.openapi.OpenApiExtension;
import run.halo.gradle.watch.WatchTarget;

public class HaloPluginExtension {
    public static final String[] MANIFEST = new String[]{"plugin.yaml", "plugin.yml"};
    public static final String EXTENSION_NAME = "haloPlugin";
    private DirectoryProperty workDir;
    private String pluginName;
    private String requires;
    private String version;
    private final Property<String> mainClass;
    private OpenApiExtension openApi;
    private File manifestFile;
    private RegularFileProperty configurationPropertiesFile;
    private NamedDomainObjectContainer<WatchTarget> watchDomains;

    public HaloPluginExtension(Project project) {
        this.watchDomains = project.container(WatchTarget.class);
        this.mainClass = project.getObjects().property(String.class);
        this.workDir = project.getObjects().directoryProperty();
        this.configurationPropertiesFile = project.getObjects().fileProperty();
        this.openApi = (OpenApiExtension)project.getObjects().newInstance(OpenApiExtension.class, new Object[]{project.getExtensions()});
        this.configurationPropertiesFile.map(file -> {
            File yaml = file.getAsFile();
            if (!yaml.exists()) {
                return null;
            }
            Path yamlPath = yaml.toPath();
            if (yamlPath.endsWith(".yaml") || yamlPath.endsWith(".yml")) {
                return yaml;
            }
            throw new IllegalArgumentException("Plugin configuration file must be a YAML file.");
        });
        this.workDir.convention(project.getLayout().getProjectDirectory().dir("workplace"));
    }

    public void openApi(Action<OpenApiExtension> action) {
        action.execute((Object)this.openApi);
    }

    public String getRequires() {
        if (this.requires == null || "*".equals(this.requires)) {
            return "latest";
        }
        return this.requires;
    }

    public void watchDomain(Action<NamedDomainObjectContainer<WatchTarget>> action) {
        action.execute(this.watchDomains);
    }

    public DirectoryProperty getWorkDir() {
        return this.workDir;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String getVersion() {
        return this.version;
    }

    public Property<String> getMainClass() {
        return this.mainClass;
    }

    public OpenApiExtension getOpenApi() {
        return this.openApi;
    }

    public File getManifestFile() {
        return this.manifestFile;
    }

    public RegularFileProperty getConfigurationPropertiesFile() {
        return this.configurationPropertiesFile;
    }

    public NamedDomainObjectContainer<WatchTarget> getWatchDomains() {
        return this.watchDomains;
    }

    public void setWorkDir(DirectoryProperty workDir) {
        this.workDir = workDir;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public void setRequires(String requires) {
        this.requires = requires;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setOpenApi(OpenApiExtension openApi) {
        this.openApi = openApi;
    }

    public void setManifestFile(File manifestFile) {
        this.manifestFile = manifestFile;
    }

    public void setConfigurationPropertiesFile(RegularFileProperty configurationPropertiesFile) {
        this.configurationPropertiesFile = configurationPropertiesFile;
    }

    public void setWatchDomains(NamedDomainObjectContainer<WatchTarget> watchDomains) {
        this.watchDomains = watchDomains;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HaloPluginExtension)) {
            return false;
        }
        HaloPluginExtension other = (HaloPluginExtension)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DirectoryProperty this$workDir = this.getWorkDir();
        DirectoryProperty other$workDir = other.getWorkDir();
        if (this$workDir == null ? other$workDir != null : !this$workDir.equals(other$workDir)) {
            return false;
        }
        String this$pluginName = this.getPluginName();
        String other$pluginName = other.getPluginName();
        if (this$pluginName == null ? other$pluginName != null : !this$pluginName.equals(other$pluginName)) {
            return false;
        }
        String this$requires = this.getRequires();
        String other$requires = other.getRequires();
        if (this$requires == null ? other$requires != null : !this$requires.equals(other$requires)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Property<String> this$mainClass = this.getMainClass();
        Property<String> other$mainClass = other.getMainClass();
        if (this$mainClass == null ? other$mainClass != null : !this$mainClass.equals(other$mainClass)) {
            return false;
        }
        OpenApiExtension this$openApi = this.getOpenApi();
        OpenApiExtension other$openApi = other.getOpenApi();
        if (this$openApi == null ? other$openApi != null : !((Object)this$openApi).equals(other$openApi)) {
            return false;
        }
        File this$manifestFile = this.getManifestFile();
        File other$manifestFile = other.getManifestFile();
        if (this$manifestFile == null ? other$manifestFile != null : !((Object)this$manifestFile).equals(other$manifestFile)) {
            return false;
        }
        RegularFileProperty this$configurationPropertiesFile = this.getConfigurationPropertiesFile();
        RegularFileProperty other$configurationPropertiesFile = other.getConfigurationPropertiesFile();
        if (this$configurationPropertiesFile == null ? other$configurationPropertiesFile != null : !this$configurationPropertiesFile.equals(other$configurationPropertiesFile)) {
            return false;
        }
        NamedDomainObjectContainer<WatchTarget> this$watchDomains = this.getWatchDomains();
        NamedDomainObjectContainer<WatchTarget> other$watchDomains = other.getWatchDomains();
        return !(this$watchDomains == null ? other$watchDomains != null : !this$watchDomains.equals(other$watchDomains));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HaloPluginExtension;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DirectoryProperty $workDir = this.getWorkDir();
        result = result * 59 + ($workDir == null ? 43 : $workDir.hashCode());
        String $pluginName = this.getPluginName();
        result = result * 59 + ($pluginName == null ? 43 : $pluginName.hashCode());
        String $requires = this.getRequires();
        result = result * 59 + ($requires == null ? 43 : $requires.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Property<String> $mainClass = this.getMainClass();
        result = result * 59 + ($mainClass == null ? 43 : $mainClass.hashCode());
        OpenApiExtension $openApi = this.getOpenApi();
        result = result * 59 + ($openApi == null ? 43 : ((Object)$openApi).hashCode());
        File $manifestFile = this.getManifestFile();
        result = result * 59 + ($manifestFile == null ? 43 : ((Object)$manifestFile).hashCode());
        RegularFileProperty $configurationPropertiesFile = this.getConfigurationPropertiesFile();
        result = result * 59 + ($configurationPropertiesFile == null ? 43 : $configurationPropertiesFile.hashCode());
        NamedDomainObjectContainer<WatchTarget> $watchDomains = this.getWatchDomains();
        result = result * 59 + ($watchDomains == null ? 43 : $watchDomains.hashCode());
        return result;
    }

    public String toString() {
        return "HaloPluginExtension(workDir=" + this.getWorkDir() + ", pluginName=" + this.getPluginName() + ", requires=" + this.getRequires() + ", version=" + this.getVersion() + ", mainClass=" + this.getMainClass() + ", openApi=" + this.getOpenApi() + ", manifestFile=" + this.getManifestFile() + ", configurationPropertiesFile=" + this.getConfigurationPropertiesFile() + ", watchDomains=" + this.getWatchDomains() + ")";
    }
}

