/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.openapi;

import java.util.HashMap;
import javax.inject.Inject;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;

public class ApiClientExtension {
    private DirectoryProperty outputDir;
    private Property<String> generatorName;
    private MapProperty<String, Object> additionalProperties;
    private MapProperty<String, String> typeMappings;

    @Inject
    public ApiClientExtension(ObjectFactory objectFactory, ProjectLayout layout) {
        this.outputDir = objectFactory.directoryProperty();
        this.generatorName = objectFactory.property(String.class);
        this.additionalProperties = objectFactory.mapProperty(String.class, Object.class);
        this.typeMappings = objectFactory.mapProperty(String.class, String.class);
        this.outputDir.convention(layout.getProjectDirectory().dir("console/src/api/generated"));
        this.generatorName.convention((Object)"typescript-axios");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("useES6", true);
        properties.put("useSingleRequestParameter", true);
        properties.put("withSeparateModelsAndApi", true);
        properties.put("apiPackage", "api");
        properties.put("modelPackage", "models");
        this.additionalProperties.convention(properties);
        HashMap<String, String> typeMappings = new HashMap<String, String>();
        typeMappings.put("set", "Array");
        this.typeMappings.convention(typeMappings);
    }

    public DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    public Property<String> getGeneratorName() {
        return this.generatorName;
    }

    public MapProperty<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public MapProperty<String, String> getTypeMappings() {
        return this.typeMappings;
    }

    public void setOutputDir(DirectoryProperty outputDir) {
        this.outputDir = outputDir;
    }

    public void setGeneratorName(Property<String> generatorName) {
        this.generatorName = generatorName;
    }

    public void setAdditionalProperties(MapProperty<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public void setTypeMappings(MapProperty<String, String> typeMappings) {
        this.typeMappings = typeMappings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiClientExtension)) {
            return false;
        }
        ApiClientExtension other = (ApiClientExtension)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DirectoryProperty this$outputDir = this.getOutputDir();
        DirectoryProperty other$outputDir = other.getOutputDir();
        if (this$outputDir == null ? other$outputDir != null : !this$outputDir.equals(other$outputDir)) {
            return false;
        }
        Property<String> this$generatorName = this.getGeneratorName();
        Property<String> other$generatorName = other.getGeneratorName();
        if (this$generatorName == null ? other$generatorName != null : !this$generatorName.equals(other$generatorName)) {
            return false;
        }
        MapProperty<String, Object> this$additionalProperties = this.getAdditionalProperties();
        MapProperty<String, Object> other$additionalProperties = other.getAdditionalProperties();
        if (this$additionalProperties == null ? other$additionalProperties != null : !this$additionalProperties.equals(other$additionalProperties)) {
            return false;
        }
        MapProperty<String, String> this$typeMappings = this.getTypeMappings();
        MapProperty<String, String> other$typeMappings = other.getTypeMappings();
        return !(this$typeMappings == null ? other$typeMappings != null : !this$typeMappings.equals(other$typeMappings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiClientExtension;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DirectoryProperty $outputDir = this.getOutputDir();
        result = result * 59 + ($outputDir == null ? 43 : $outputDir.hashCode());
        Property<String> $generatorName = this.getGeneratorName();
        result = result * 59 + ($generatorName == null ? 43 : $generatorName.hashCode());
        MapProperty<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : $additionalProperties.hashCode());
        MapProperty<String, String> $typeMappings = this.getTypeMappings();
        result = result * 59 + ($typeMappings == null ? 43 : $typeMappings.hashCode());
        return result;
    }

    public String toString() {
        return "ApiClientExtension(outputDir=" + this.getOutputDir() + ", generatorName=" + this.getGeneratorName() + ", additionalProperties=" + this.getAdditionalProperties() + ", typeMappings=" + this.getTypeMappings() + ")";
    }
}

