/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.openapi;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.openapitools.codegen.DefaultGenerator;
import org.openapitools.codegen.config.CodegenConfigurator;
import run.halo.gradle.extension.HaloPluginExtension;
import run.halo.gradle.openapi.ApiClientExtension;
import run.halo.gradle.openapi.OpenApiExtension;
import run.halo.gradle.utils.FileUtils;

public class ApiClientGeneratorTask
extends DefaultTask {
    @Input
    private final Property<String> generatorName = this.getProject().getObjects().property(String.class);
    @Input
    private final MapProperty<String, String> groupedApiMappings;
    @Input
    @Optional
    private final MapProperty<String, Object> additionalProperties;
    @Input
    @Optional
    private final MapProperty<String, String> typeMappings;
    @Internal
    private final DirectoryProperty specDir;
    @Internal
    private final DirectoryProperty outputDir = this.getProject().getObjects().directoryProperty();

    @Inject
    public ApiClientGeneratorTask() {
        this.specDir = this.getProject().getObjects().directoryProperty();
        this.additionalProperties = this.getProject().getObjects().mapProperty(String.class, Object.class);
        this.typeMappings = this.getProject().getObjects().mapProperty(String.class, String.class);
        this.groupedApiMappings = this.getProject().getObjects().mapProperty(String.class, String.class);
        HaloPluginExtension pluginExtension = (HaloPluginExtension)this.getProject().getExtensions().getByType(HaloPluginExtension.class);
        OpenApiExtension openApi = pluginExtension.getOpenApi();
        this.specDir.convention((Provider)openApi.getOutputDir());
        this.groupedApiMappings.convention(openApi.getGroupedApiMappings());
        ApiClientExtension generator = openApi.getGenerator();
        this.outputDir.convention((Provider)generator.getOutputDir());
        this.generatorName.convention(generator.getGeneratorName());
        this.additionalProperties.convention(generator.getAdditionalProperties());
        this.typeMappings.convention(generator.getTypeMappings());
    }

    @TaskAction
    public void generate() throws IOException {
        if (!this.groupedApiMappings.isPresent()) {
            return;
        }
        Path outputPath = ((Directory)this.outputDir.get()).getAsFile().toPath();
        if (Files.exists(outputPath, new LinkOption[0])) {
            FileUtils.deleteRecursively(outputPath);
        }
        for (String value : ((Map)this.groupedApiMappings.get()).values()) {
            File inputSpec = ((RegularFile)this.specDir.file(value).get()).getAsFile();
            CodegenConfigurator configurator = new CodegenConfigurator();
            configurator.setInputSpec(inputSpec.getAbsolutePath());
            configurator.setOutputDir(outputPath.toString());
            configurator.setGeneratorName((String)this.generatorName.get());
            configurator.setAdditionalProperties((Map)this.additionalProperties.get());
            configurator.setTypeMappings((Map)this.typeMappings.get());
            DefaultGenerator generator = new DefaultGenerator();
            generator.opts(configurator.toClientOptInput()).generate();
        }
    }

    public Property<String> getGeneratorName() {
        return this.generatorName;
    }

    public MapProperty<String, String> getGroupedApiMappings() {
        return this.groupedApiMappings;
    }

    public MapProperty<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public MapProperty<String, String> getTypeMappings() {
        return this.typeMappings;
    }

    public DirectoryProperty getSpecDir() {
        return this.specDir;
    }

    public DirectoryProperty getOutputDir() {
        return this.outputDir;
    }
}

