/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.openapi;

import com.github.dockerjava.api.DockerClient;
import javax.annotation.Nonnull;
import org.gradle.api.file.Directory;
import org.gradle.api.internal.tasks.execution.ExecuteTaskBuildOperationDetails;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import run.halo.gradle.docker.DockerClientConfiguration;
import run.halo.gradle.docker.DockerClientService;

public abstract class CleanupApiServerContainer
implements BuildService<Params>,
BuildOperationListener {
    public void started(@Nonnull BuildOperationDescriptor buildOperationDescriptor, @Nonnull OperationStartEvent operationStartEvent) {
    }

    public void progress(@Nonnull OperationIdentifier operationIdentifier, @Nonnull OperationProgressEvent operationProgressEvent) {
    }

    public void finished(@Nonnull BuildOperationDescriptor buildOperation, @Nonnull OperationFinishEvent finishEvent) {
        Object details = buildOperation.getDetails();
        if (details instanceof ExecuteTaskBuildOperationDetails) {
            ExecuteTaskBuildOperationDetails executeTaskDetails = (ExecuteTaskBuildOperationDetails)details;
            String name = executeTaskDetails.getTask().getName();
            if (!"generateOpenApiDocs".contains(name)) {
                return;
            }
            DockerClientService dockerClientService = (DockerClientService)((Params)this.getParameters()).getDockerClientService().getOrNull();
            if (dockerClientService == null) {
                return;
            }
            try (DockerClient dockerClient = this.getDockerClient(dockerClientService);){
                dockerClient.removeContainerCmd("halo-openapi-docs-generator").withForce(Boolean.valueOf(true)).exec();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    DockerClient getDockerClient(DockerClientService dockerClientService) {
        return dockerClientService.getDockerClient(this.createDockerClientConfig(dockerClientService));
    }

    private DockerClientConfiguration createDockerClientConfig(DockerClientService dockerClientService) {
        DockerClientService.Params parameters = (DockerClientService.Params)dockerClientService.getParameters();
        DockerClientConfiguration dockerClientConfig = new DockerClientConfiguration();
        dockerClientConfig.setUrl((String)parameters.getUrl().getOrNull());
        dockerClientConfig.setCertPath((Directory)parameters.getCertPath().getOrNull());
        dockerClientConfig.setApiVersion((String)parameters.getApiVersion().getOrNull());
        return dockerClientConfig;
    }

    public static interface Params
    extends BuildServiceParameters {
        public Property<DockerClientService> getDockerClientService();
    }
}

