/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.openapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Volume;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.halo.gradle.docker.DockerExistingImage;
import run.halo.gradle.docker.FrameConsumerResultCallback;
import run.halo.gradle.docker.OutputFrame;
import run.halo.gradle.docker.ToStringConsumer;
import run.halo.gradle.extension.HaloExtension;
import run.halo.gradle.extension.HaloPluginExtension;
import run.halo.gradle.openapi.OpenApiExtension;
import run.halo.gradle.utils.Assert;
import run.halo.gradle.utils.FileUtils;
import run.halo.gradle.utils.HaloServerConfigure;
import run.halo.gradle.utils.YamlUtils;

public class OpenApiDocsGeneratorTask
extends DockerExistingImage {
    private static final Logger log = LoggerFactory.getLogger(OpenApiDocsGeneratorTask.class);
    public static final String CONTAINER_NAME = "halo-openapi-docs-generator";
    public static final String TASK_NAME = "generateOpenApiDocs";
    @Internal
    final HaloPluginExtension pluginExtension = (HaloPluginExtension)this.getProject().getExtensions().getByType(HaloPluginExtension.class);
    @Input
    @Optional
    final Property<String> platform = this.getProject().getObjects().property(String.class);
    @Input
    @Optional
    final MapProperty<String, String> requestHeaders = this.getProject().getObjects().mapProperty(String.class, String.class);
    @Input
    final MapProperty<String, String> groupedApiMappings = this.getProject().getObjects().mapProperty(String.class, String.class);
    @Input
    @Optional
    final Property<String> trustStore = this.getProject().getObjects().property(String.class);
    @Input
    @Optional
    final Property<char[]> trustStorePassword = this.getProject().getObjects().property(char[].class);
    @Input
    final Property<String> apiDocsVersion = this.getProject().getObjects().property(String.class);
    @Internal
    final Property<Integer> waitTimeInSeconds = this.getProject().getObjects().property(Integer.class);
    @Internal
    final Property<String> apiDocsUrl = this.getProject().getObjects().property(String.class);
    @Internal
    final Property<Integer> port = this.getProject().getObjects().property(Integer.class);
    @Internal
    final DirectoryProperty outputDir = this.getProject().getObjects().directoryProperty();
    @Internal
    final Property<String> containerId = this.getProject().getObjects().property(String.class);
    @Internal
    final List<SpringDocGroupConfig> springDocGroupConfigs = new ArrayList<SpringDocGroupConfig>();

    public OpenApiDocsGeneratorTask() {
        OpenApiExtension openApi = this.pluginExtension.getOpenApi();
        openApi.getGroupingRules().getAsMap().forEach((group, config) -> this.springDocGroupConfigs.add(SpringDocGroupConfig.builder().group((String)group).displayName((String)config.getDisplayName().get()).pathsToMatch((List)config.getPathsToMatch().get()).pathsToExclude((List)config.getPathsToExclude().get()).build()));
        this.groupedApiMappings.convention(openApi.getGroupedApiMappings());
        this.requestHeaders.convention(openApi.getRequestHeaders());
        this.waitTimeInSeconds.convention(openApi.getWaitTimeInSeconds());
        this.apiDocsUrl.convention(openApi.getApiDocsUrl());
        this.port.convention(openApi.getApiDocsPort());
        this.outputDir.convention((Provider)openApi.getOutputDir());
        this.apiDocsVersion.convention(openApi.getApiDocsVersion());
    }

    @Override
    public void runRemoteCommand() throws Exception {
        if (!this.groupedApiMappings.isPresent() || ((Map)this.groupedApiMappings.get()).isEmpty()) {
            throw new IllegalArgumentException("No 'groupedApiMappings' found, please configure it in the 'haloPlugin.openApi' in the build.gradle file first.");
        }
        File outputDirFile = (File)this.outputDir.getAsFile().get();
        Path outputFilePath = outputDirFile.toPath();
        if (Files.exists(outputFilePath, new LinkOption[0])) {
            FileUtils.deleteRecursively(outputFilePath);
        }
        try (DockerClient dockerClient = this.getDockerClient();){
            this.prepareApiDocsServer(dockerClient);
            ApiDocGenerator apiDocGenerator = ApiDocGenerator.builder().outputDir(outputDirFile).requestHeaders((Map)this.requestHeaders.get()).trustStore(this.trustStore).trustStorePassword(this.trustStorePassword).waitTimeInSeconds((Integer)this.waitTimeInSeconds.get()).build();
            ((Map)this.groupedApiMappings.get()).forEach((k, v) -> {
                String url = this.joinUrl((String)this.apiDocsUrl.get(), (String)k);
                ReadinessCheck.builder().dockerClient(dockerClient).containerId((String)this.containerId.get()).endpoint(url).requestHeaders((Map)this.requestHeaders.get()).build().awaitReadiness();
                apiDocGenerator.generateApiDocs(url, (String)v);
            });
            this.removeContainer(dockerClient);
        }
    }

    private String joinUrl(String baseUrl, String path) {
        return StringUtils.removeEnd((String)baseUrl, (String)"/") + "/" + StringUtils.removeStart((String)path, (String)"/");
    }

    private void prepareApiDocsServer(DockerClient dockerClient) {
        String imageId = (String)this.getImageId().get();
        try {
            this.removeContainer(dockerClient);
            CreateContainerCmd containerCommand = dockerClient.createContainerCmd(imageId);
            this.setContainerCommandConfig(containerCommand);
            CreateContainerResponse container = containerCommand.exec();
            this.containerId.convention((Object)container.getId());
            log.info("Created container with ID [{}]", (Object)CONTAINER_NAME);
            Action<? super Object> nextHandler = this.getNextHandler();
            if (nextHandler != null) {
                nextHandler.execute((Object)container);
            }
            dockerClient.startContainerCmd(container.getId()).exec();
            FrameConsumerResultCallback callback = new FrameConsumerResultCallback();
            ToStringConsumer toStringConsumer = new ToStringConsumer();
            callback.addConsumer(OutputFrame.OutputType.STDOUT, toStringConsumer);
            callback.addConsumer(OutputFrame.OutputType.STDERR, toStringConsumer);
            dockerClient.attachContainerCmd(container.getId()).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).withLogs(Boolean.valueOf(true)).exec((ResultCallback)callback);
            ReadinessCheck.builder().dockerClient(dockerClient).containerId(container.getId()).endpoint(this.joinUrl((String)this.apiDocsUrl.get(), "/actuator/health")).requestHeaders((Map)this.requestHeaders.get()).waitTimeInSeconds(180).build().awaitReadiness();
        }
        catch (Exception e) {
            throw new GradleException("Failed to start Halo application", (Throwable)e);
        }
    }

    void removeContainer(DockerClient dockerClient) {
        try {
            dockerClient.removeContainerCmd(CONTAINER_NAME).withForce(Boolean.valueOf(true)).exec();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void setContainerCommandConfig(CreateContainerCmd containerCommand) {
        HaloExtension haloExtension = (HaloExtension)this.getProject().getExtensions().getByType(HaloExtension.class);
        containerCommand.withName(CONTAINER_NAME);
        if (this.platform.getOrNull() != null) {
            containerCommand.withPlatform((String)this.platform.get());
        }
        int containerPort = (Integer)this.port.get();
        containerCommand.withCmd(new String[]{"--rm"});
        String pluginName = this.pluginExtension.getPluginName();
        ArrayList<CallSite> envs = new ArrayList<CallSite>();
        String applicationJson = HaloServerConfigure.builder().port(containerPort).externalUrl(haloExtension.getExternalUrl()).fixedPluginPath(HaloServerConfigure.buildPluginDestPath(pluginName)).build().mergeWithUserConfigAsJson(this.generateUserDefinedApplicationConfig());
        envs.add((CallSite)((Object)("SPRING_APPLICATION_JSON=" + applicationJson)));
        containerCommand.withEnv(envs);
        containerCommand.withImage((String)this.getImageId().get());
        containerCommand.withLabels(Map.of("halo.container.createdBy", CONTAINER_NAME));
        ArrayList<ExposedPort> exposedPorts = new ArrayList<ExposedPort>(2);
        exposedPorts.add(ExposedPort.parse((String)String.valueOf(containerPort)));
        containerCommand.withExposedPorts(exposedPorts);
        ArrayList<PortBinding> portBindings = new ArrayList<PortBinding>(2);
        portBindings.add(PortBinding.parse((String)"%s:%s".formatted(containerPort, containerPort)));
        HostConfig hostConfig = new HostConfig();
        hostConfig.withPortBindings(portBindings);
        File projectDir = (File)this.getProject().getLayout().getBuildDirectory().getAsFile().get();
        ArrayList<Bind> binds = new ArrayList<Bind>();
        binds.add(new Bind(projectDir.toString(), new Volume(HaloServerConfigure.buildPluginDestPath(pluginName) + "build")));
        File pluginConfigYaml = (File)this.pluginExtension.getConfigurationPropertiesFile().getAsFile().getOrNull();
        if (pluginConfigYaml != null && Files.exists(pluginConfigYaml.toPath(), new LinkOption[0])) {
            binds.add(new Bind(pluginConfigYaml.getAbsolutePath(), new Volume(HaloServerConfigure.buildPluginConfigYamlPath(haloExtension.getServerWorkDir(), pluginName))));
        }
        hostConfig.withBinds(binds);
        containerCommand.withHostConfig(hostConfig);
    }

    JsonNode generateUserDefinedApplicationConfig() {
        String springDocYaml = OpenApiDocsGeneratorTask.generateSpringDocConfigString(this.springDocGroupConfigs);
        if (StringUtils.isBlank((CharSequence)springDocYaml)) {
            return JsonNodeFactory.instance.missingNode();
        }
        return YamlUtils.read(springDocYaml, JsonNode.class);
    }

    static String generateSpringDocConfigString(@Nonnull List<SpringDocGroupConfig> configs) {
        if (configs.isEmpty()) {
            return null;
        }
        StringBuilder yamlBuilder = new StringBuilder();
        yamlBuilder.append("springdoc:\n").append("  group-configs:\n");
        for (SpringDocGroupConfig entry : configs) {
            String group = entry.group();
            List<String> pathsToMatch = entry.pathsToMatch;
            List<String> pathsToExclude = entry.pathsToExclude();
            String displayName = entry.displayName();
            yamlBuilder.append("    - group: ").append(group).append("\n").append("      displayName: ").append(displayName).append("\n");
            if (!pathsToMatch.isEmpty()) {
                yamlBuilder.append("      paths-to-match:\n");
                for (String path : pathsToMatch) {
                    yamlBuilder.append("        - ").append(path).append("\n");
                }
            }
            if (pathsToExclude.isEmpty()) continue;
            yamlBuilder.append("      paths-to-exclude:\n");
            for (String path : pathsToExclude) {
                yamlBuilder.append("        - ").append(path).append("\n");
            }
        }
        return yamlBuilder.toString();
    }

    public HaloPluginExtension getPluginExtension() {
        return this.pluginExtension;
    }

    public Property<String> getPlatform() {
        return this.platform;
    }

    public MapProperty<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public MapProperty<String, String> getGroupedApiMappings() {
        return this.groupedApiMappings;
    }

    public Property<String> getTrustStore() {
        return this.trustStore;
    }

    public Property<char[]> getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public Property<String> getApiDocsVersion() {
        return this.apiDocsVersion;
    }

    public Property<Integer> getWaitTimeInSeconds() {
        return this.waitTimeInSeconds;
    }

    public Property<String> getApiDocsUrl() {
        return this.apiDocsUrl;
    }

    public Property<Integer> getPort() {
        return this.port;
    }

    public DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    public Property<String> getContainerId() {
        return this.containerId;
    }

    public List<SpringDocGroupConfig> getSpringDocGroupConfigs() {
        return this.springDocGroupConfigs;
    }

    record ApiDocGenerator(File outputDir, Map<String, String> requestHeaders, Property<String> trustStore, Property<char[]> trustStorePassword, Integer waitTimeInSeconds) {
        private static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).build();

        public void generateApiDocs(String url, String fileName) {
            boolean isYaml = url.toLowerCase(Locale.getDefault()).matches(".+[./]yaml(/.+)*");
            try {
                String apiDocs;
                SSLContext sslContext = this.getCustomSslContext();
                log.info("Generating OpenApi Docs..");
                HttpURLConnection connection = this.getHttpURLConnection(url, sslContext);
                String response = new String(connection.getInputStream().readAllBytes(), StandardCharsets.UTF_8);
                String string = apiDocs = isYaml ? response : this.prettifyJson(response);
                if (!this.outputDir.exists()) {
                    Files.createDirectories(this.outputDir.toPath(), new FileAttribute[0]);
                }
                File outputFile = new File(this.outputDir, fileName);
                try (FileWriter writer = new FileWriter(outputFile);){
                    writer.write(apiDocs);
                }
            }
            catch (Exception e) {
                log.error("Unable to connect to {} waited for {} seconds", new Object[]{url, this.waitTimeInSeconds, e});
                throw new RuntimeException("Unable to connect to " + url + " waited for " + this.waitTimeInSeconds + " seconds", e);
            }
        }

        private HttpURLConnection getHttpURLConnection(String url, SSLContext sslContext) throws IOException {
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("GET");
            for (Map.Entry<String, String> header : this.requestHeaders.entrySet()) {
                connection.setRequestProperty(header.getKey(), header.getValue());
            }
            connection.connect();
            return connection;
        }

        public SSLContext getCustomSslContext() throws Exception {
            if (this.trustStore.isPresent()) {
                log.debug("Reading truststore: {}", this.trustStore.get());
                try (FileInputStream truststoreFile = new FileInputStream((String)this.trustStore.get());){
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    KeyStore truststore = KeyStore.getInstance(KeyStore.getDefaultType());
                    truststore.load(truststoreFile, (char[])this.trustStorePassword.get());
                    trustManagerFactory.init(truststore);
                    SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
                    KeyManager[] keyManagers = new KeyManager[]{};
                    sslContext.init(keyManagers, trustManagerFactory.getTrustManagers(), new SecureRandom());
                    SSLContext sSLContext = sslContext;
                    return sSLContext;
                }
            }
            return SSLContext.getDefault();
        }

        private String prettifyJson(String response) {
            try {
                JsonNode jsonObject = OBJECT_MAPPER.readTree(response);
                ObjectWriter writer = OBJECT_MAPPER.writerWithDefaultPrettyPrinter();
                return writer.writeValueAsString((Object)jsonObject);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Failed to parse the API docs response string. Please ensure that the response is in the correct format. response=" + response, e);
            }
        }

        public static ApiDocGeneratorBuilder builder() {
            return new ApiDocGeneratorBuilder();
        }

        public static class ApiDocGeneratorBuilder {
            private File outputDir;
            private Map<String, String> requestHeaders;
            private Property<String> trustStore;
            private Property<char[]> trustStorePassword;
            private Integer waitTimeInSeconds;

            ApiDocGeneratorBuilder() {
            }

            public ApiDocGeneratorBuilder outputDir(File outputDir) {
                this.outputDir = outputDir;
                return this;
            }

            public ApiDocGeneratorBuilder requestHeaders(Map<String, String> requestHeaders) {
                this.requestHeaders = requestHeaders;
                return this;
            }

            public ApiDocGeneratorBuilder trustStore(Property<String> trustStore) {
                this.trustStore = trustStore;
                return this;
            }

            public ApiDocGeneratorBuilder trustStorePassword(Property<char[]> trustStorePassword) {
                this.trustStorePassword = trustStorePassword;
                return this;
            }

            public ApiDocGeneratorBuilder waitTimeInSeconds(Integer waitTimeInSeconds) {
                this.waitTimeInSeconds = waitTimeInSeconds;
                return this;
            }

            public ApiDocGenerator build() {
                return new ApiDocGenerator(this.outputDir, this.requestHeaders, this.trustStore, this.trustStorePassword, this.waitTimeInSeconds);
            }

            public String toString() {
                return "OpenApiDocsGeneratorTask.ApiDocGenerator.ApiDocGeneratorBuilder(outputDir=" + this.outputDir + ", requestHeaders=" + this.requestHeaders + ", trustStore=" + this.trustStore + ", trustStorePassword=" + this.trustStorePassword + ", waitTimeInSeconds=" + this.waitTimeInSeconds + ")";
            }
        }
    }

    record ReadinessCheck(DockerClient dockerClient, String containerId, String endpoint, Map<String, String> requestHeaders, Integer waitTimeInSeconds) {
        private static final int MAX_HTTP_STATUS_CODE = 299;
        private static final int INITIAL_DELAY = 0;
        private static final int PERIOD = 1;
        private static final TimeUnit TIME_UNIT = TimeUnit.SECONDS;
        private static final int TIMEOUT = 60;

        public ReadinessCheck {
            Assert.notNull(endpoint, "Endpoint must not be null");
            Assert.notNull(dockerClient, "DockerClient must not be null");
            Assert.notNull(containerId, "ContainerId must not be null");
            if (requestHeaders == null) {
                requestHeaders = Collections.emptyMap();
            }
            if (waitTimeInSeconds == null) {
                waitTimeInSeconds = 60;
            }
        }

        private boolean containerIsRunning() {
            InspectContainerResponse containerInfo = this.dockerClient.inspectContainerCmd(this.containerId).exec();
            return Boolean.TRUE.equals(containerInfo.getState().getRunning());
        }

        public void awaitReadiness() {
            ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
            try {
                CompletableFuture readinessFuture = new CompletableFuture();
                ScheduledFuture<?> scheduledFuture = scheduler.scheduleAtFixedRate(() -> {
                    try {
                        if (!this.containerIsRunning()) {
                            readinessFuture.completeExceptionally((Throwable)new GradleException("Container is stopped unexpectedly"));
                        }
                        if (this.isReadiness()) {
                            readinessFuture.complete(true);
                        }
                    }
                    catch (Exception e) {
                        readinessFuture.completeExceptionally(e);
                    }
                }, 0L, 1L, TIME_UNIT);
                readinessFuture.whenComplete((result, throwable) -> {
                    if (throwable != null) {
                        log.error("Filed to start Halo application", throwable);
                    }
                    scheduledFuture.cancel(true);
                });
                readinessFuture.get(60L, TIME_UNIT);
            }
            catch (TimeoutException e) {
                log.error("Timeout to wait for container readiness");
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
            finally {
                scheduler.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isReadiness() throws Exception {
            URL url = new URL(this.endpoint);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            this.requestHeaders.forEach(connection::setRequestProperty);
            try {
                int responseCode = connection.getResponseCode();
                log.trace("apiDocsUrl = {} status code = {}", (Object)url, (Object)responseCode);
                boolean bl = responseCode < 299;
                return bl;
            }
            catch (SocketException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                connection.disconnect();
            }
        }

        public static ReadinessCheckBuilder builder() {
            return new ReadinessCheckBuilder();
        }

        public static class ReadinessCheckBuilder {
            private DockerClient dockerClient;
            private String containerId;
            private String endpoint;
            private Map<String, String> requestHeaders;
            private Integer waitTimeInSeconds;

            ReadinessCheckBuilder() {
            }

            public ReadinessCheckBuilder dockerClient(DockerClient dockerClient) {
                this.dockerClient = dockerClient;
                return this;
            }

            public ReadinessCheckBuilder containerId(String containerId) {
                this.containerId = containerId;
                return this;
            }

            public ReadinessCheckBuilder endpoint(String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            public ReadinessCheckBuilder requestHeaders(Map<String, String> requestHeaders) {
                this.requestHeaders = requestHeaders;
                return this;
            }

            public ReadinessCheckBuilder waitTimeInSeconds(Integer waitTimeInSeconds) {
                this.waitTimeInSeconds = waitTimeInSeconds;
                return this;
            }

            public ReadinessCheck build() {
                return new ReadinessCheck(this.dockerClient, this.containerId, this.endpoint, this.requestHeaders, this.waitTimeInSeconds);
            }

            public String toString() {
                return "OpenApiDocsGeneratorTask.ReadinessCheck.ReadinessCheckBuilder(dockerClient=" + this.dockerClient + ", containerId=" + this.containerId + ", endpoint=" + this.endpoint + ", requestHeaders=" + this.requestHeaders + ", waitTimeInSeconds=" + this.waitTimeInSeconds + ")";
            }
        }
    }

    record SpringDocGroupConfig(String group, String displayName, List<String> pathsToMatch, List<String> pathsToExclude) {
        public SpringDocGroupConfig {
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = group;
            }
            if (pathsToMatch == null) {
                pathsToMatch = Collections.emptyList();
            }
            if (pathsToExclude == null) {
                pathsToExclude = Collections.emptyList();
            }
        }

        public static SpringDocGroupConfigBuilder builder() {
            return new SpringDocGroupConfigBuilder();
        }

        public static class SpringDocGroupConfigBuilder {
            private String group;
            private String displayName;
            private List<String> pathsToMatch;
            private List<String> pathsToExclude;

            SpringDocGroupConfigBuilder() {
            }

            public SpringDocGroupConfigBuilder group(String group) {
                this.group = group;
                return this;
            }

            public SpringDocGroupConfigBuilder displayName(String displayName) {
                this.displayName = displayName;
                return this;
            }

            public SpringDocGroupConfigBuilder pathsToMatch(List<String> pathsToMatch) {
                this.pathsToMatch = pathsToMatch;
                return this;
            }

            public SpringDocGroupConfigBuilder pathsToExclude(List<String> pathsToExclude) {
                this.pathsToExclude = pathsToExclude;
                return this;
            }

            public SpringDocGroupConfig build() {
                return new SpringDocGroupConfig(this.group, this.displayName, this.pathsToMatch, this.pathsToExclude);
            }

            public String toString() {
                return "OpenApiDocsGeneratorTask.SpringDocGroupConfig.SpringDocGroupConfigBuilder(group=" + this.group + ", displayName=" + this.displayName + ", pathsToMatch=" + this.pathsToMatch + ", pathsToExclude=" + this.pathsToExclude + ")";
            }
        }
    }
}

