/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.openapi;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Random;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import run.halo.gradle.extension.HaloExtension;
import run.halo.gradle.openapi.ApiClientExtension;
import run.halo.gradle.openapi.GroupedOpenApiExtension;

public class OpenApiExtension {
    private static final int DEFAULT_WAIT_TIME_IN_SECONDS = 30;
    private DirectoryProperty outputDir;
    private MapProperty<String, String> groupedApiMappings;
    private MapProperty<String, String> requestHeaders;
    private Property<Integer> waitTimeInSeconds;
    private Property<String> trustStore;
    private Property<char[]> trustStorePassword;
    private Property<String> apiDocsUrl;
    private Property<Integer> apiDocsPort;
    private Property<String> apiDocsVersion;
    private ApiClientExtension generator;
    private NamedDomainObjectContainer<GroupedOpenApiExtension> groupingRules;

    @Inject
    public OpenApiExtension(ExtensionContainer extensions, ObjectFactory objectFactory, ProjectLayout layout) {
        this.outputDir = objectFactory.directoryProperty();
        this.groupedApiMappings = objectFactory.mapProperty(String.class, String.class);
        this.requestHeaders = objectFactory.mapProperty(String.class, String.class);
        this.waitTimeInSeconds = objectFactory.property(Integer.class);
        this.trustStore = objectFactory.property(String.class);
        this.trustStorePassword = objectFactory.property(char[].class);
        this.apiDocsUrl = objectFactory.property(String.class);
        this.apiDocsPort = objectFactory.property(Integer.class);
        this.apiDocsVersion = objectFactory.property(String.class);
        this.generator = (ApiClientExtension)objectFactory.newInstance(ApiClientExtension.class, new Object[0]);
        this.groupingRules = objectFactory.domainObjectContainer(GroupedOpenApiExtension.class, name -> (GroupedOpenApiExtension)objectFactory.newInstance(GroupedOpenApiExtension.class, new Object[]{name}));
        this.outputDir.convention(layout.getBuildDirectory().dir("api-docs/openapi/v3_0"));
        this.groupedApiMappings.convention(Collections.emptyMap());
        this.requestHeaders.convention(Collections.emptyMap());
        this.waitTimeInSeconds.convention((Object)30);
        this.apiDocsPort.convention((Object)AvailablePortFinder.findRandomAvailablePort());
        this.apiDocsVersion.convention((Object)"OPENAPI_3_0");
        this.conventionApiDocsUrl(extensions);
    }

    public void generator(Action<ApiClientExtension> action) {
        action.execute((Object)this.generator);
    }

    public void groupingRules(Action<NamedDomainObjectContainer<GroupedOpenApiExtension>> action) {
        action.execute(this.groupingRules);
    }

    private void conventionApiDocsUrl(ExtensionContainer extensions) {
        HaloExtension haloExtension = (HaloExtension)extensions.getByType(HaloExtension.class);
        URI externalUri = URI.create(haloExtension.getExternalUrl());
        try {
            URI uri = new URI(externalUri.getScheme(), null, externalUri.getHost(), (Integer)this.apiDocsPort.get(), null, null, null);
            this.apiDocsUrl.convention((Object)uri.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to create API docs URL", e);
        }
    }

    public DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    public MapProperty<String, String> getGroupedApiMappings() {
        return this.groupedApiMappings;
    }

    public MapProperty<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public Property<Integer> getWaitTimeInSeconds() {
        return this.waitTimeInSeconds;
    }

    public Property<String> getTrustStore() {
        return this.trustStore;
    }

    public Property<char[]> getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public Property<String> getApiDocsUrl() {
        return this.apiDocsUrl;
    }

    public Property<Integer> getApiDocsPort() {
        return this.apiDocsPort;
    }

    public Property<String> getApiDocsVersion() {
        return this.apiDocsVersion;
    }

    public ApiClientExtension getGenerator() {
        return this.generator;
    }

    public NamedDomainObjectContainer<GroupedOpenApiExtension> getGroupingRules() {
        return this.groupingRules;
    }

    public void setOutputDir(DirectoryProperty outputDir) {
        this.outputDir = outputDir;
    }

    public void setGroupedApiMappings(MapProperty<String, String> groupedApiMappings) {
        this.groupedApiMappings = groupedApiMappings;
    }

    public void setRequestHeaders(MapProperty<String, String> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public void setWaitTimeInSeconds(Property<Integer> waitTimeInSeconds) {
        this.waitTimeInSeconds = waitTimeInSeconds;
    }

    public void setTrustStore(Property<String> trustStore) {
        this.trustStore = trustStore;
    }

    public void setTrustStorePassword(Property<char[]> trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public void setApiDocsUrl(Property<String> apiDocsUrl) {
        this.apiDocsUrl = apiDocsUrl;
    }

    public void setApiDocsPort(Property<Integer> apiDocsPort) {
        this.apiDocsPort = apiDocsPort;
    }

    public void setApiDocsVersion(Property<String> apiDocsVersion) {
        this.apiDocsVersion = apiDocsVersion;
    }

    public void setGenerator(ApiClientExtension generator) {
        this.generator = generator;
    }

    public void setGroupingRules(NamedDomainObjectContainer<GroupedOpenApiExtension> groupingRules) {
        this.groupingRules = groupingRules;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenApiExtension)) {
            return false;
        }
        OpenApiExtension other = (OpenApiExtension)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DirectoryProperty this$outputDir = this.getOutputDir();
        DirectoryProperty other$outputDir = other.getOutputDir();
        if (this$outputDir == null ? other$outputDir != null : !this$outputDir.equals(other$outputDir)) {
            return false;
        }
        MapProperty<String, String> this$groupedApiMappings = this.getGroupedApiMappings();
        MapProperty<String, String> other$groupedApiMappings = other.getGroupedApiMappings();
        if (this$groupedApiMappings == null ? other$groupedApiMappings != null : !this$groupedApiMappings.equals(other$groupedApiMappings)) {
            return false;
        }
        MapProperty<String, String> this$requestHeaders = this.getRequestHeaders();
        MapProperty<String, String> other$requestHeaders = other.getRequestHeaders();
        if (this$requestHeaders == null ? other$requestHeaders != null : !this$requestHeaders.equals(other$requestHeaders)) {
            return false;
        }
        Property<Integer> this$waitTimeInSeconds = this.getWaitTimeInSeconds();
        Property<Integer> other$waitTimeInSeconds = other.getWaitTimeInSeconds();
        if (this$waitTimeInSeconds == null ? other$waitTimeInSeconds != null : !this$waitTimeInSeconds.equals(other$waitTimeInSeconds)) {
            return false;
        }
        Property<String> this$trustStore = this.getTrustStore();
        Property<String> other$trustStore = other.getTrustStore();
        if (this$trustStore == null ? other$trustStore != null : !this$trustStore.equals(other$trustStore)) {
            return false;
        }
        Property<char[]> this$trustStorePassword = this.getTrustStorePassword();
        Property<char[]> other$trustStorePassword = other.getTrustStorePassword();
        if (this$trustStorePassword == null ? other$trustStorePassword != null : !this$trustStorePassword.equals(other$trustStorePassword)) {
            return false;
        }
        Property<String> this$apiDocsUrl = this.getApiDocsUrl();
        Property<String> other$apiDocsUrl = other.getApiDocsUrl();
        if (this$apiDocsUrl == null ? other$apiDocsUrl != null : !this$apiDocsUrl.equals(other$apiDocsUrl)) {
            return false;
        }
        Property<Integer> this$apiDocsPort = this.getApiDocsPort();
        Property<Integer> other$apiDocsPort = other.getApiDocsPort();
        if (this$apiDocsPort == null ? other$apiDocsPort != null : !this$apiDocsPort.equals(other$apiDocsPort)) {
            return false;
        }
        Property<String> this$apiDocsVersion = this.getApiDocsVersion();
        Property<String> other$apiDocsVersion = other.getApiDocsVersion();
        if (this$apiDocsVersion == null ? other$apiDocsVersion != null : !this$apiDocsVersion.equals(other$apiDocsVersion)) {
            return false;
        }
        ApiClientExtension this$generator = this.getGenerator();
        ApiClientExtension other$generator = other.getGenerator();
        if (this$generator == null ? other$generator != null : !((Object)this$generator).equals(other$generator)) {
            return false;
        }
        NamedDomainObjectContainer<GroupedOpenApiExtension> this$groupingRules = this.getGroupingRules();
        NamedDomainObjectContainer<GroupedOpenApiExtension> other$groupingRules = other.getGroupingRules();
        return !(this$groupingRules == null ? other$groupingRules != null : !this$groupingRules.equals(other$groupingRules));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenApiExtension;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DirectoryProperty $outputDir = this.getOutputDir();
        result = result * 59 + ($outputDir == null ? 43 : $outputDir.hashCode());
        MapProperty<String, String> $groupedApiMappings = this.getGroupedApiMappings();
        result = result * 59 + ($groupedApiMappings == null ? 43 : $groupedApiMappings.hashCode());
        MapProperty<String, String> $requestHeaders = this.getRequestHeaders();
        result = result * 59 + ($requestHeaders == null ? 43 : $requestHeaders.hashCode());
        Property<Integer> $waitTimeInSeconds = this.getWaitTimeInSeconds();
        result = result * 59 + ($waitTimeInSeconds == null ? 43 : $waitTimeInSeconds.hashCode());
        Property<String> $trustStore = this.getTrustStore();
        result = result * 59 + ($trustStore == null ? 43 : $trustStore.hashCode());
        Property<char[]> $trustStorePassword = this.getTrustStorePassword();
        result = result * 59 + ($trustStorePassword == null ? 43 : $trustStorePassword.hashCode());
        Property<String> $apiDocsUrl = this.getApiDocsUrl();
        result = result * 59 + ($apiDocsUrl == null ? 43 : $apiDocsUrl.hashCode());
        Property<Integer> $apiDocsPort = this.getApiDocsPort();
        result = result * 59 + ($apiDocsPort == null ? 43 : $apiDocsPort.hashCode());
        Property<String> $apiDocsVersion = this.getApiDocsVersion();
        result = result * 59 + ($apiDocsVersion == null ? 43 : $apiDocsVersion.hashCode());
        ApiClientExtension $generator = this.getGenerator();
        result = result * 59 + ($generator == null ? 43 : ((Object)$generator).hashCode());
        NamedDomainObjectContainer<GroupedOpenApiExtension> $groupingRules = this.getGroupingRules();
        result = result * 59 + ($groupingRules == null ? 43 : $groupingRules.hashCode());
        return result;
    }

    public String toString() {
        return "OpenApiExtension(outputDir=" + this.getOutputDir() + ", groupedApiMappings=" + this.getGroupedApiMappings() + ", requestHeaders=" + this.getRequestHeaders() + ", waitTimeInSeconds=" + this.getWaitTimeInSeconds() + ", trustStore=" + this.getTrustStore() + ", trustStorePassword=" + this.getTrustStorePassword() + ", apiDocsUrl=" + this.getApiDocsUrl() + ", apiDocsPort=" + this.getApiDocsPort() + ", apiDocsVersion=" + this.getApiDocsVersion() + ", generator=" + this.getGenerator() + ", groupingRules=" + this.getGroupingRules() + ")";
    }

    static final class AvailablePortFinder {
        private static final int MIN_PORT = 30000;
        private static final int MAX_PORT = 65534;

        public static int findRandomAvailablePort() {
            int port;
            boolean isAvailable;
            Random random = new Random();
            while (!(isAvailable = AvailablePortFinder.isPortAvailable(port = random.nextInt(35535) + 30000))) {
            }
            return port;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private static boolean isPortAvailable(int port) {
            try (ServerSocket serverSocket = new ServerSocket(port);){
                DatagramSocket datagramSocket = new DatagramSocket(port);
                try {
                    boolean bl = true;
                    datagramSocket.close();
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        datagramSocket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                return false;
            }
        }

        private AvailablePortFinder() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

