/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.steps;

import java.io.IOException;
import java.net.URI;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.halo.gradle.steps.HaloSiteOption;
import run.halo.gradle.steps.HttpClientFactory;
import run.halo.gradle.utils.Assert;

public class ReloadPluginStep {
    private static final Logger log = LoggerFactory.getLogger(ReloadPluginStep.class);
    private final HttpClientFactory httpClientFactory;
    private final URI externalUrl;

    public ReloadPluginStep(HaloSiteOption haloSiteOption) {
        Assert.notNull(haloSiteOption, "The haloSiteOption must not be null.");
        this.httpClientFactory = new HttpClientFactory(haloSiteOption);
        this.externalUrl = haloSiteOption.externalUrl();
    }

    public void execute(String pluginName) {
        try (CloseableHttpClient client = this.httpClientFactory.create();){
            this.reloadPlugin((HttpClient)client, pluginName);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isSuccessful(HttpResponse response) {
        return response.getCode() >= 200 && response.getCode() < 300;
    }

    private void reloadPlugin(HttpClient client, String pluginName) throws IOException, InterruptedException {
        HttpPut httpPut = new HttpPut(this.externalUrl.resolve("/apis/api.console.halo.run/v1alpha1/plugins/" + pluginName + "/reload"));
        HttpResponse response = client.execute((ClassicHttpRequest)httpPut);
        if (!this.isSuccessful(response)) {
            throw new RuntimeException("Reload plugin failed, " + response.getReasonPhrase());
        }
        log.info("Reload plugin successfully.");
    }
}

