/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.steps;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.halo.gradle.steps.HaloSiteOption;
import run.halo.gradle.utils.Assert;
import run.halo.gradle.utils.RetryUtils;
import run.halo.gradle.utils.YamlUtils;

public class SetupHaloStep {
    private static final Logger log = LoggerFactory.getLogger(SetupHaloStep.class);
    private final HaloSiteOption haloSiteOption;

    public SetupHaloStep(HaloSiteOption haloSiteOption) {
        Assert.notNull(haloSiteOption, "haloSiteOption must not be null");
        this.haloSiteOption = haloSiteOption;
    }

    public void execute() {
        try (CloseableHttpClient client = HttpClients.createDefault();){
            this.waitForReadiness(client);
            this.setup(client);
            String output = ConsoleOutputFormatter.printFormatted("> Halo \u542f\u52a8\u6210\u529f\uff01", this.requestUri("/console?language=zh-CN"), this.haloSiteOption.username(), this.haloSiteOption.password(), this.requestUri("swagger-ui.html"));
            System.out.println(output);
        }
        catch (IOException | ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private void waitForReadiness(CloseableHttpClient client) {
        HttpGet httpGet = new HttpGet(this.requestUri("/actuator/health"));
        RetryUtils.withRetry(20, 400L, () -> {
            try {
                CloseableHttpResponse response = client.execute((ClassicHttpRequest)httpGet);
                String body = EntityUtils.toString((HttpEntity)response.getEntity());
                return SetupHaloStep.isSuccessful(response) && SetupHaloStep.isUp(body);
            }
            catch (Exception e) {
                return false;
            }
        });
    }

    static boolean isUp(String body) throws JsonProcessingException {
        return YamlUtils.mapper.readTree(body).path("status").asText().equalsIgnoreCase("UP");
    }

    private void setup(CloseableHttpClient client) throws IOException, ParseException {
        JsonNode globalInfo = this.fetchGlobalInfo(client);
        if (this.isUserInitialized(globalInfo)) {
            return;
        }
        this.executeSetupRequest(client);
    }

    private void executeSetupRequest(CloseableHttpClient client) throws IOException, ParseException {
        HttpPost initializeRequest = this.getSetupRequest();
        CloseableHttpResponse response = client.execute((ClassicHttpRequest)initializeRequest);
        if (SetupHaloStep.isSuccessful(response)) {
            log.info("Initialize system successfully.");
        } else {
            log.error("Initialize system failed: {}", (Object)EntityUtils.toString((HttpEntity)response.getEntity()));
        }
    }

    private JsonNode fetchGlobalInfo(CloseableHttpClient client) throws IOException, ParseException {
        HttpGet globalInfoHttpGet = new HttpGet(this.requestUri("/actuator/globalinfo"));
        CloseableHttpResponse globalInfoResp = client.execute((ClassicHttpRequest)globalInfoHttpGet);
        String bodyStr = EntityUtils.toString((HttpEntity)globalInfoResp.getEntity());
        return YamlUtils.mapper.readTree(bodyStr);
    }

    private boolean isUserInitialized(JsonNode globalInfo) {
        JsonNode userInitialized = globalInfo.get("userInitialized");
        return userInitialized != null && userInitialized.asBoolean();
    }

    private HttpPost getSetupRequest() {
        HttpPost setupRequest = new HttpPost(this.requestUri("/system/setup"));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(List.of(new BasicNameValuePair("siteTitle", "Halo"), new BasicNameValuePair("username", this.haloSiteOption.username()), new BasicNameValuePair("password", this.haloSiteOption.password()), new BasicNameValuePair("email", "custom@halo.run")));
        setupRequest.setEntity((HttpEntity)entity);
        setupRequest.addHeader("Accept", (Object)"application/json");
        return setupRequest;
    }

    URI requestUri(String path) {
        return this.haloSiteOption.externalUrl().resolve(path);
    }

    private static boolean isSuccessful(CloseableHttpResponse response) {
        return response.getCode() >= 200 && response.getCode() < 300;
    }

    static class ConsoleOutputFormatter {
        ConsoleOutputFormatter() {
        }

        public static String printFormatted(String title, URI url, String username, String password, URI apiDoc) {
            String[] lines = new String[]{String.format("%s", title), String.format("\u8bbf\u95ee\u5730\u5740\uff1a%s", url), String.format("\u7528\u6237\u540d\uff1a%s", username), String.format("\u5bc6\u7801\uff1a%s", password), String.format("API \u6587\u6863\uff1a%s", apiDoc), "\u63d2\u4ef6\u5f00\u53d1\u6587\u6863\uff1ahttps://docs.halo.run/developer-guide/plugin/introduction"};
            int maxWidth = 0;
            for (String line : lines) {
                int width = ConsoleOutputFormatter.getDisplayWidth(line);
                if (width <= maxWidth) continue;
                maxWidth = width;
            }
            String ANSI_GREEN = "\u001b[32m";
            String ANSI_RESET = "\u001b[0m";
            String border = ConsoleOutputFormatter.repeatChar('=', maxWidth);
            StringBuilder sb = new StringBuilder();
            sb.append("\u001b[32m").append(border).append("\u001b[0m").append("\n");
            for (String line : lines) {
                String paddedLine = ConsoleOutputFormatter.padRight(line, maxWidth);
                sb.append(paddedLine).append("\n");
            }
            sb.append("\u001b[32m").append(border).append("\u001b[0m").append("\n");
            return sb.toString();
        }

        public static int getDisplayWidth(String s) {
            int charCount;
            int width = 0;
            for (int offset = 0; offset < s.length(); offset += charCount) {
                int codePoint = s.codePointAt(offset);
                charCount = Character.charCount(codePoint);
                if (ConsoleOutputFormatter.isFullWidth(codePoint)) {
                    width += 2;
                    continue;
                }
                ++width;
            }
            return width;
        }

        public static boolean isFullWidth(int codePoint) {
            return codePoint >= 4352 && codePoint <= 4447 || codePoint >= 11904 && codePoint <= 42191 || codePoint >= 44032 && codePoint <= 55203 || codePoint >= 63744 && codePoint <= 64255 || codePoint >= 65040 && codePoint <= 65049 || codePoint >= 65072 && codePoint <= 65135 || codePoint >= 65280 && codePoint <= 65376 || codePoint >= 65504 && codePoint <= 65510;
        }

        public static String padRight(String s, int totalWidth) {
            int displayWidth = ConsoleOutputFormatter.getDisplayWidth(s);
            int paddingWidth = totalWidth - displayWidth;
            return s + " ".repeat(Math.max(0, paddingWidth));
        }

        public static String repeatChar(char ch, int count) {
            return String.valueOf(ch).repeat(Math.max(0, count));
        }
    }
}

