/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.mergepatch.JsonMergePatch;
import java.util.HashMap;
import java.util.Map;
import run.halo.gradle.utils.Assert;
import run.halo.gradle.utils.PathUtils;
import run.halo.gradle.utils.YamlUtils;

public class HaloServerConfigure {
    private final String workDir;
    private final Integer port;
    private final String externalUrl;
    private final String fixedPluginPath;

    public JsonNode getServerConfig() {
        try {
            return (JsonNode)YamlUtils.mapper.readValue(this.renderConfig(), JsonNode.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private String renderConfig() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("port", this.port.toString());
        props.put("externalUrl", this.externalUrl);
        props.put("fixedPluginPath", this.fixedPluginPath);
        props.put("workDir", this.workDir);
        return HaloServerConfigure.replaceTemplate("server:\n  port: {port}\nspring:\n  thymeleaf:\n    cache: false\n  web:\n    resources:\n      cache:\n        cachecontrol:\n          no-cache: true\n        use-last-modified: false\nhalo:\n  security:\n    basic-auth:\n      disabled: false\n  external-url: {externalUrl}\n  plugin:\n    runtime-mode: development\n    fixed-plugin-path:\n      - {fixedPluginPath}\n  work-dir: {workDir}\nlogging:\n  level:\n    run.halo.app: DEBUG\n    org.springframework.boot.autoconfigure.web.reactive.error.AbstractErrorWebExceptionHandler: DEBUG\nspringdoc:\n  cache:\n    disabled: true\n  api-docs:\n    enabled: true\n    version: OPENAPI_3_0\n  swagger-ui:\n    enabled: true\n  show-actuator: true\nmanagement:\n  endpoints:\n    web:\n      exposure:\n        include: \"*\"\n", props);
    }

    public static String replaceTemplate(String template, Map<String, String> valuesMap) {
        StringBuilder result = new StringBuilder();
        int cursor = 0;
        while (cursor < template.length()) {
            int start = template.indexOf(123, cursor);
            if (start == -1) {
                result.append(template.substring(cursor));
                break;
            }
            int end = template.indexOf(125, start);
            if (end == -1) {
                throw new IllegalArgumentException("Unmatched '{' at position " + start);
            }
            result.append(template, cursor, start);
            String key = template.substring(start + 1, end);
            String replacement = valuesMap.getOrDefault(key, "{" + key + "}");
            result.append(replacement);
            cursor = end + 1;
        }
        return result.toString();
    }

    public String mergeWithUserConfigAsJson(JsonNode userDefined) {
        Assert.notNull(userDefined, "The 'userDefined' must not be null");
        if (userDefined.isMissingNode() || userDefined.isNull()) {
            return this.getServerConfig().toPrettyString();
        }
        JsonNode defaultConfig = this.getServerConfig();
        try {
            JsonMergePatch jsonMergePatch = JsonMergePatch.fromJson((JsonNode)userDefined);
            JsonNode patchedNode = jsonMergePatch.apply(defaultConfig);
            return patchedNode.toPrettyString();
        }
        catch (JsonPatchException e) {
            throw new RuntimeException(e);
        }
    }

    public static String buildPluginDestPath(String pluginName) {
        return "/data/plugins/" + pluginName + "/";
    }

    public static String buildPluginConfigYamlPath(String haloWorkDir, String pluginName) {
        return PathUtils.combinePath(haloWorkDir, "plugins/configs/" + pluginName + ".yaml");
    }

    private static Integer $default$port() {
        return 8090;
    }

    private static String $default$externalUrl() {
        return "http://localhost:8090";
    }

    public static HaloServerConfigureBuilder builder() {
        return new HaloServerConfigureBuilder();
    }

    public HaloServerConfigure(String workDir, Integer port, String externalUrl, String fixedPluginPath) {
        this.workDir = workDir;
        this.port = port;
        this.externalUrl = externalUrl;
        this.fixedPluginPath = fixedPluginPath;
    }

    public static class HaloServerConfigureBuilder {
        private String workDir;
        private boolean port$set;
        private Integer port$value;
        private boolean externalUrl$set;
        private String externalUrl$value;
        private String fixedPluginPath;

        HaloServerConfigureBuilder() {
        }

        public HaloServerConfigureBuilder workDir(String workDir) {
            this.workDir = workDir;
            return this;
        }

        public HaloServerConfigureBuilder port(Integer port) {
            this.port$value = port;
            this.port$set = true;
            return this;
        }

        public HaloServerConfigureBuilder externalUrl(String externalUrl) {
            this.externalUrl$value = externalUrl;
            this.externalUrl$set = true;
            return this;
        }

        public HaloServerConfigureBuilder fixedPluginPath(String fixedPluginPath) {
            this.fixedPluginPath = fixedPluginPath;
            return this;
        }

        public HaloServerConfigure build() {
            Integer port$value = this.port$value;
            if (!this.port$set) {
                port$value = HaloServerConfigure.$default$port();
            }
            String externalUrl$value = this.externalUrl$value;
            if (!this.externalUrl$set) {
                externalUrl$value = HaloServerConfigure.$default$externalUrl();
            }
            return new HaloServerConfigure(this.workDir, port$value, externalUrl$value, this.fixedPluginPath);
        }

        public String toString() {
            return "HaloServerConfigure.HaloServerConfigureBuilder(workDir=" + this.workDir + ", port$value=" + this.port$value + ", externalUrl$value=" + this.externalUrl$value + ", fixedPluginPath=" + this.fixedPluginPath + ")";
        }
    }
}

