/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import run.halo.gradle.utils.Assert;

public class MainClassFinder {
    private static final String DOT_CLASS = ".class";
    private static final FileFilter CLASS_FILE_FILTER = MainClassFinder::isClassFile;
    private static final FileFilter PACKAGE_DIRECTORY_FILTER = MainClassFinder::isPackageDirectory;

    private static boolean isClassFile(File file) {
        return file.isFile() && file.getName().endsWith(DOT_CLASS);
    }

    private static boolean isPackageDirectory(File file) {
        return file.isDirectory() && !file.getName().startsWith(".");
    }

    public static String findSingleMainClass(File rootDirectory, String superClassName) throws IOException {
        return MainClassFinder.doWithMainClasses(rootDirectory, superClassName);
    }

    static String doWithMainClasses(File rootDirectory, String superClassName) throws IOException {
        if (!rootDirectory.exists()) {
            return null;
        }
        if (!rootDirectory.isDirectory()) {
            throw new IllegalArgumentException("Invalid root directory '" + rootDirectory + "'");
        }
        String prefix = rootDirectory.getAbsolutePath() + "/";
        ArrayDeque<File> stack = new ArrayDeque<File>();
        stack.push(rootDirectory);
        while (!stack.isEmpty()) {
            File file = (File)stack.pop();
            if (file.isFile()) {
                try (FileInputStream inputStream = new FileInputStream(file);){
                    ClassReader classReader = new ClassReader((InputStream)inputStream);
                    ClassDescriptor classDescriptor = new ClassDescriptor(superClassName);
                    classReader.accept((ClassVisitor)classDescriptor, 1);
                    if (StringUtils.isNotBlank((CharSequence)classDescriptor.getMainClassName())) {
                        String string = MainClassFinder.convertToClassName(file.getAbsolutePath(), prefix);
                        return string;
                    }
                }
            }
            if (!file.isDirectory()) continue;
            MainClassFinder.pushAllSorted(stack, file.listFiles(PACKAGE_DIRECTORY_FILTER));
            MainClassFinder.pushAllSorted(stack, file.listFiles(CLASS_FILE_FILTER));
        }
        return null;
    }

    private static void pushAllSorted(Deque<File> stack, File[] files) {
        Arrays.sort(files, Comparator.comparing(File::getName));
        for (File file : files) {
            stack.push(file);
        }
    }

    private static String convertToClassName(String name, String prefix) {
        name = name.replace('/', '.');
        name = name.replace('\\', '.');
        name = name.substring(0, name.length() - DOT_CLASS.length());
        if (prefix != null) {
            name = name.substring(prefix.length());
        }
        return name;
    }

    private static class ClassDescriptor
    extends ClassVisitor {
        private final Set<String> mainClassNames = new HashSet<String>();
        private final String superClassPath;

        ClassDescriptor(String superClassName) {
            super(589824);
            Assert.notNull(superClassName, "Super class name must not be null");
            Assert.state(!superClassName.startsWith(".") && !superClassName.endsWith(MainClassFinder.DOT_CLASS), () -> "Super class name must not start with '.'");
            this.superClassPath = superClassName.replace('.', '/');
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (superName.equals(this.superClassPath)) {
                boolean isAbstract;
                boolean isPublic = (access & 1) != 0;
                boolean bl = isAbstract = (access & 0x400) != 0;
                if (isPublic && !isAbstract) {
                    this.mainClassNames.add(name);
                }
            }
        }

        public String getMainClassName() {
            if (this.mainClassNames.size() > 1) {
                throw new IllegalStateException("Unable to find a single main class from the following candidates " + this.mainClassNames);
            }
            return this.mainClassNames.isEmpty() ? null : this.mainClassNames.iterator().next();
        }
    }
}

