/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.watch;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import run.halo.gradle.utils.Assert;

public class ChangedFile {
    private final File sourceDirectory;
    private final File file;
    private final Type type;

    public ChangedFile(File sourceDirectory, File file, Type type) {
        Assert.notNull(sourceDirectory, "SourceDirectory must not be null");
        Assert.notNull(file, "File must not be null");
        Assert.notNull((Object)type, "Type must not be null");
        this.sourceDirectory = sourceDirectory;
        this.file = file;
        this.type = type;
    }

    public File getFile() {
        return this.file;
    }

    public Type getType() {
        return this.type;
    }

    public String getRelativeName() {
        File directory = this.sourceDirectory.getAbsoluteFile();
        File file = this.file.getAbsoluteFile();
        String directoryName = FilenameUtils.normalize((String)directory.getPath());
        String fileName = FilenameUtils.normalize((String)file.getPath());
        Assert.state(fileName.startsWith(directoryName), () -> "The file " + fileName + " is not contained in the source directory " + directoryName);
        return fileName.substring(directoryName.length() + 1);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ChangedFile) {
            ChangedFile other = (ChangedFile)obj;
            return this.file.equals(other.file) && this.type.equals((Object)other.type);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.file.hashCode() * 31 + this.type.hashCode();
    }

    public String toString() {
        return this.file + " (" + this.type + ")";
    }

    public static enum Type {
        ADD,
        MODIFY,
        DELETE;

    }
}

