/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.watch;

import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import run.halo.gradle.utils.Assert;
import run.halo.gradle.watch.ChangedFile;
import run.halo.gradle.watch.ChangedFiles;
import run.halo.gradle.watch.FileSnapshot;

public class DirectorySnapshot {
    private static final Set<String> DOTS = Set.of(".", "..");
    private final File directory;
    private final Date time;
    private final Set<FileSnapshot> files;
    private final FileFilter excludeFilter;

    DirectorySnapshot(File directory, FileFilter excludeFilter) {
        Assert.notNull(directory, "Directory must not be null");
        Assert.isTrue(!directory.isFile(), () -> "Directory '" + directory + "' must not be a file");
        this.directory = directory;
        this.time = new Date();
        this.excludeFilter = excludeFilter;
        LinkedHashSet<FileSnapshot> files = new LinkedHashSet<FileSnapshot>();
        this.collectFiles(directory, files);
        this.files = Collections.unmodifiableSet(files);
    }

    private void collectFiles(File source, Set<FileSnapshot> result) {
        File[] children = source.listFiles();
        if (children != null) {
            for (File child : children) {
                if (this.excludeFilter != null && this.excludeFilter.accept(child)) continue;
                if (child.isDirectory() && !DOTS.contains(child.getName())) {
                    this.collectFiles(child, result);
                    continue;
                }
                if (!child.isFile()) continue;
                result.add(new FileSnapshot(child));
            }
        }
    }

    ChangedFiles getChangedFiles(DirectorySnapshot snapshot, FileFilter triggerFilter) {
        Assert.notNull(snapshot, "Snapshot must not be null");
        File directory = this.directory;
        Assert.isTrue(snapshot.directory.equals(directory), () -> "Snapshot source directory must be '" + directory + "'");
        LinkedHashSet<ChangedFile> changes = new LinkedHashSet<ChangedFile>();
        Map<File, FileSnapshot> previousFiles = this.getFilesMap();
        for (FileSnapshot currentFile : snapshot.files) {
            if (!this.acceptChangedFile(triggerFilter, currentFile)) continue;
            FileSnapshot previousFile = previousFiles.remove(currentFile.getFile());
            if (previousFile == null) {
                changes.add(new ChangedFile(directory, currentFile.getFile(), ChangedFile.Type.ADD));
                continue;
            }
            if (previousFile.equals(currentFile)) continue;
            changes.add(new ChangedFile(directory, currentFile.getFile(), ChangedFile.Type.MODIFY));
        }
        for (FileSnapshot previousFile : previousFiles.values()) {
            if (!this.acceptChangedFile(triggerFilter, previousFile)) continue;
            changes.add(new ChangedFile(directory, previousFile.getFile(), ChangedFile.Type.DELETE));
        }
        return new ChangedFiles(directory, changes);
    }

    private boolean acceptChangedFile(FileFilter triggerFilter, FileSnapshot file) {
        return triggerFilter == null || !triggerFilter.accept(file.getFile());
    }

    private Map<File, FileSnapshot> getFilesMap() {
        LinkedHashMap<File, FileSnapshot> files = new LinkedHashMap<File, FileSnapshot>();
        for (FileSnapshot file : this.files) {
            files.put(file.getFile(), file);
        }
        return files;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof DirectorySnapshot) {
            return this.equals((DirectorySnapshot)obj, null);
        }
        return super.equals(obj);
    }

    boolean equals(DirectorySnapshot other, FileFilter filter) {
        if (this.directory.equals(other.directory)) {
            Set<FileSnapshot> ourFiles = this.filter(this.files, filter);
            Set<FileSnapshot> otherFiles = this.filter(other.files, filter);
            return ourFiles.equals(otherFiles);
        }
        return false;
    }

    private Set<FileSnapshot> filter(Set<FileSnapshot> source, FileFilter filter) {
        if (filter == null) {
            return source;
        }
        LinkedHashSet<FileSnapshot> filtered = new LinkedHashSet<FileSnapshot>();
        for (FileSnapshot file : source) {
            if (!filter.accept(file.getFile())) continue;
            filtered.add(file);
        }
        return filtered;
    }

    public int hashCode() {
        int hashCode = this.directory.hashCode();
        hashCode = 31 * hashCode + this.files.hashCode();
        return hashCode;
    }

    File getDirectory() {
        return this.directory;
    }

    public String toString() {
        return this.directory + " snapshot at " + this.time;
    }
}

