/*
 * Decompiled with CFR 0.152.
 */
package run.iget.framework.captcha.service.impl;

import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.wf.captcha.SpecCaptcha;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import run.iget.framework.captcha.req.CaptchaReq;
import run.iget.framework.captcha.resp.CaptchaResp;
import run.iget.framework.captcha.service.CaptchaService;
import run.iget.framework.common.enums.BaseResultEnum;
import run.iget.framework.common.util.ExceptionThrowUtils;

@Service
public class CaptchaServiceImpl
implements CaptchaService {
    private static final Logger log = LoggerFactory.getLogger(CaptchaServiceImpl.class);
    private static final TimedCache<String, String> CAPTCHA_TIMED_CACHE = new TimedCache(TIME_OUT.longValue());

    @Override
    public CaptchaResp generate() {
        SpecCaptcha captcha = new SpecCaptcha(150, 40);
        captcha.setLen(5);
        captcha.setCharType(1);
        String text = captcha.text();
        String key = IdUtil.fastSimpleUUID();
        CaptchaResp resp = new CaptchaResp();
        resp.setKey(key);
        resp.setImage(captcha.toBase64());
        log.info("key: {}, captcha: {}", (Object)key, (Object)text);
        CAPTCHA_TIMED_CACHE.put((Object)resp.getKey(), (Object)text);
        return resp;
    }

    @Override
    public void verify(CaptchaReq captchaReq) {
        String key = captchaReq.getKey();
        ExceptionThrowUtils.ofTrue((Boolean)StrUtil.hasBlank((CharSequence[])new CharSequence[]{key, captchaReq.getCaptcha()}), BaseResultEnum.ERROR_CAPTCHA);
        String cache = (String)CAPTCHA_TIMED_CACHE.get((Object)captchaReq.getKey(), false);
        ExceptionThrowUtils.ofTrue((Boolean)(!StrUtil.equals((CharSequence)cache, (CharSequence)captchaReq.getCaptcha(), (boolean)true) ? 1 : 0), BaseResultEnum.ERROR_CAPTCHA);
        CAPTCHA_TIMED_CACHE.remove((Object)captchaReq.getKey());
    }

    static {
        CAPTCHA_TIMED_CACHE.schedulePrune(1000L);
    }
}

