/*
 * Decompiled with CFR 0.152.
 */
package run.iget.framework.common.enums;

import java.util.Objects;
import run.iget.framework.common.enums.BaseEnum;

public enum BaseStatusEnum implements BaseEnum<Integer>
{
    ENABLE(0, "\u542f\u7528"),
    DISABLE(1, "\u7981\u7528");

    private Integer code;
    private String desc;

    private BaseStatusEnum(int value, String description) {
        this.code = value;
        this.desc = description;
    }

    public static boolean isDisable(Integer value) {
        return Objects.equals(value, BaseStatusEnum.DISABLE.code);
    }

    public static BaseStatusEnum negate(BaseStatusEnum statusEnum) {
        if (statusEnum == null) {
            return null;
        }
        return BaseStatusEnum.negate(statusEnum.code);
    }

    public static BaseStatusEnum negate(Integer statusCode) {
        if (statusCode == null) {
            return null;
        }
        return BaseStatusEnum.isDisable(statusCode) ? ENABLE : DISABLE;
    }

    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }
}

