/*
 * Decompiled with CFR 0.152.
 */
package run.iget.framework.common.handler;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import run.iget.framework.common.enums.BaseResultEnum;
import run.iget.framework.common.exception.BusinessException;
import run.iget.framework.common.resp.ResultResp;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    @Value(value="${fast.framework.consoleError:false}")
    private Boolean consoleError;

    @ExceptionHandler(value={BusinessException.class})
    public ResultResp<String> handleException(BusinessException ex) {
        BaseResultEnum resultEnum = ex.getResultEnum();
        this.consoleErrorMsg(ex);
        return ResultResp.error((String)resultEnum.getCode(), resultEnum.getDesc());
    }

    @ExceptionHandler(value={BindException.class})
    public ResultResp<String> bindException(BindException ex) {
        FieldError fieldError = ex.getFieldError();
        assert (fieldError != null);
        this.consoleErrorMsg((Exception)ex);
        return ResultResp.error((String)BaseResultEnum.ERROR_PARAM.getCode(), fieldError.getDefaultMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public ResultResp<String> handleException(Exception ex) {
        this.consoleErrorMsg(ex);
        return ResultResp.error(ex.getMessage());
    }

    private void consoleErrorMsg(Exception ex) {
        if (!Boolean.TRUE.equals(this.consoleError) || !log.isErrorEnabled()) {
            return;
        }
        log.error(ex.getMessage(), (Throwable)ex);
    }

    public void setConsoleError(Boolean consoleError) {
        this.consoleError = consoleError;
    }
}

