/*
 * Decompiled with CFR 0.152.
 */
package run.iget.framework.common.handler;

import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;
import run.iget.framework.common.resp.ResultResp;

@RestControllerAdvice
public class RestControllerAdviceHandler
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(RestControllerAdviceHandler.class);

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType mediaType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse serverHttpResponse) {
        if (body instanceof ResultResp) {
            return body;
        }
        if (mediaType != MediaType.APPLICATION_JSON) {
            serverHttpResponse.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        }
        ResultResp<Object> responseEntity = ResultResp.ok(body);
        if (body instanceof String) {
            return JSON.toJSONString(responseEntity);
        }
        return responseEntity;
    }
}

