/*
 * Decompiled with CFR 0.152.
 */
package run.iget.framework.common.resp;

import run.iget.framework.common.enums.BaseResultEnum;

public class ResultResp<T> {
    private String code;
    private String msg;
    private String module;
    private T data;

    public static <T> ResultResp<T> ok() {
        return ResultResp.ok(null);
    }

    public static <T> ResultResp<T> ok(T data) {
        return ResultResp.of(BaseResultEnum.SUCCESS, data);
    }

    public static <T> ResultResp<T> error() {
        return ResultResp.error(BaseResultEnum.ERROR_500);
    }

    public static <T> ResultResp<T> error(String msg) {
        return ResultResp.error((String)BaseResultEnum.ERROR_500.getCode(), msg);
    }

    public static <T> ResultResp<T> error(BaseResultEnum errorCode) {
        return ResultResp.error((String)errorCode.getCode(), errorCode.getDesc());
    }

    public static <T> ResultResp<T> error(String code, String msg) {
        ResultResp<T> result = new ResultResp<T>();
        result.setCode(code);
        result.setMsg(msg);
        result.setModule(BaseResultEnum.ERROR_500.getModule());
        return result;
    }

    public static <T> ResultResp<T> of(BaseResultEnum moduleEnum, T data) {
        ResultResp<T> result = new ResultResp<T>();
        result.setCode((String)moduleEnum.getCode());
        result.setMsg(moduleEnum.getDesc());
        result.setModule(moduleEnum.getModule());
        result.setData(data);
        return result;
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getModule() {
        return this.module;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultResp)) {
            return false;
        }
        ResultResp other = (ResultResp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        String this$module = this.getModule();
        String other$module = other.getModule();
        if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResultResp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        String $module = this.getModule();
        result = result * 59 + ($module == null ? 43 : $module.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ResultResp(code=" + this.getCode() + ", msg=" + this.getMsg() + ", module=" + this.getModule() + ", data=" + this.getData() + ")";
    }
}

