/*
 * Decompiled with CFR 0.152.
 */
package run.iget.framework.common.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import run.iget.framework.common.enums.BaseResultEnum;
import run.iget.framework.common.exception.BusinessException;
import run.iget.framework.common.util.CheckUtils;

public final class ExceptionThrowUtils {
    public static void ofTrue(Boolean obj) {
        ExceptionThrowUtils.ofTrue(obj, BaseResultEnum.ERROR_PARAM);
    }

    public static void ofTrue(Boolean obj, String msg) {
        ExceptionThrowUtils.ofTrue(obj, (String)BaseResultEnum.ERROR_PARAM.getCode(), msg);
    }

    public static void ofTrue(Boolean obj, String code, String msg) {
        if (Objects.equals(Boolean.TRUE, obj)) {
            ExceptionThrowUtils.of(code, msg);
        }
    }

    public static void ofTrue(Boolean obj, BaseResultEnum resultEnum) {
        if (Objects.equals(Boolean.TRUE, obj)) {
            ExceptionThrowUtils.of(resultEnum);
        }
    }

    public static void ofAnyTrue(Boolean ... obj) {
        ExceptionThrowUtils.ofAnyTrue(BaseResultEnum.ERROR_PARAM, obj);
    }

    public static void ofAnyTrue(String msg, Boolean ... obj) {
        ExceptionThrowUtils.ofAnyTrue((String)BaseResultEnum.ERROR_PARAM.getCode(), msg, obj);
    }

    public static void ofAnyTrue(String code, String msg, Boolean ... obj) {
        if (CheckUtils.isAnyTrue(obj)) {
            ExceptionThrowUtils.of(code, msg);
        }
    }

    public static void ofAnyTrue(BaseResultEnum resultEnum, Boolean ... obj) {
        if (CheckUtils.isAnyTrue(obj)) {
            ExceptionThrowUtils.of(resultEnum);
        }
    }

    public static void ofAllTrue(Boolean ... obj) {
        ExceptionThrowUtils.ofAllTrue(BaseResultEnum.ERROR_PARAM, obj);
    }

    public static void ofAllTrue(String msg, Boolean ... obj) {
        ExceptionThrowUtils.ofAllTrue((String)BaseResultEnum.ERROR_PARAM.getCode(), msg, obj);
    }

    public static void ofAllTrue(String code, String msg, Boolean ... obj) {
        if (CheckUtils.isAllTrue(obj)) {
            ExceptionThrowUtils.of(code, msg);
        }
    }

    public static void ofAllTrue(BaseResultEnum resultEnum, Boolean ... obj) {
        if (CheckUtils.isAllTrue(obj)) {
            ExceptionThrowUtils.of(resultEnum);
        }
    }

    public static void ofNotTrue(Boolean obj) {
        ExceptionThrowUtils.ofNotTrue(obj, BaseResultEnum.ERROR_PARAM);
    }

    public static void ofNotTrue(Boolean obj, String msg) {
        ExceptionThrowUtils.ofNotTrue(obj, (String)BaseResultEnum.ERROR_PARAM.getCode(), msg);
    }

    public static void ofNotTrue(Boolean obj, String code, String msg) {
        if (!Objects.equals(Boolean.TRUE, obj)) {
            ExceptionThrowUtils.of(code, msg);
        }
    }

    public static void ofNotTrue(Boolean obj, BaseResultEnum resultEnum) {
        if (!Objects.equals(Boolean.TRUE, obj)) {
            ExceptionThrowUtils.of(resultEnum);
        }
    }

    public static void ofFalse(Boolean obj) {
        ExceptionThrowUtils.ofFalse(obj, BaseResultEnum.ERROR_PARAM);
    }

    public static void ofFalse(Boolean obj, String msg) {
        ExceptionThrowUtils.ofFalse(obj, (String)BaseResultEnum.ERROR_PARAM.getCode(), msg);
    }

    public static void ofFalse(Boolean obj, String code, String msg) {
        if (Objects.equals(Boolean.FALSE, obj)) {
            ExceptionThrowUtils.of(code, msg);
        }
    }

    public static void ofFalse(Boolean obj, BaseResultEnum resultEnum) {
        if (Objects.equals(Boolean.FALSE, obj)) {
            ExceptionThrowUtils.of(resultEnum);
        }
    }

    public static void ofNotFalse(Boolean obj) {
        ExceptionThrowUtils.ofNotFalse(obj, BaseResultEnum.ERROR_PARAM);
    }

    public static void ofNotFalse(Boolean obj, String msg) {
        ExceptionThrowUtils.ofNotFalse(obj, (String)BaseResultEnum.ERROR_PARAM.getCode(), msg);
    }

    public static void ofNotFalse(Boolean obj, String code, String msg) {
        if (!Objects.equals(Boolean.FALSE, obj)) {
            ExceptionThrowUtils.of(code, msg);
        }
    }

    public static void ofNotFalse(Boolean obj, BaseResultEnum resultEnum) {
        if (!Objects.equals(Boolean.FALSE, obj)) {
            ExceptionThrowUtils.of(resultEnum);
        }
    }

    public static void ofNull(Object obj) {
        ExceptionThrowUtils.ofNull(obj, BaseResultEnum.ERROR_PARAM);
    }

    public static void ofNull(Object obj, String msg) {
        ExceptionThrowUtils.ofNull(obj, null, msg);
    }

    public static void ofNull(Object obj, String code, String msg) {
        ExceptionThrowUtils.ofTrue(Objects.isNull(obj), code, msg);
    }

    public static void ofNull(Object obj, BaseResultEnum resultEnum) {
        ExceptionThrowUtils.ofTrue((Boolean)Objects.isNull(obj), resultEnum);
    }

    public static void ofNotNull(Object obj) {
        ExceptionThrowUtils.ofNull(obj, BaseResultEnum.ERROR_PARAM);
    }

    public static void ofNotNull(Object obj, String msg) {
        ExceptionThrowUtils.ofNull(obj, null, msg);
    }

    public static void ofNotNull(Object obj, String code, String msg) {
        ExceptionThrowUtils.ofTrue(Objects.nonNull(obj), code, msg);
    }

    public static void ofNotNull(Object obj, BaseResultEnum resultEnum) {
        ExceptionThrowUtils.ofTrue((Boolean)Objects.nonNull(obj), resultEnum);
    }

    public static void ofEmpty(Map obj) {
        ExceptionThrowUtils.ofEmpty(obj, BaseResultEnum.ERROR_PARAM);
    }

    public static void ofEmpty(Map obj, String msg) {
        ExceptionThrowUtils.ofEmpty(obj, (String)BaseResultEnum.ERROR_PARAM.getCode(), msg);
    }

    public static void ofEmpty(Map obj, String code, String msg) {
        if (CollectionUtil.isEmpty((Map)obj)) {
            ExceptionThrowUtils.of(code, msg);
        }
    }

    public static void ofEmpty(Map obj, BaseResultEnum resultEnum) {
        if (CollectionUtil.isEmpty((Map)obj)) {
            ExceptionThrowUtils.of(resultEnum);
        }
    }

    public static void ofNotEmpty(Map obj) {
        ExceptionThrowUtils.ofNotEmpty(obj, BaseResultEnum.ERROR_PARAM);
    }

    public static void ofNotEmpty(Map obj, String msg) {
        ExceptionThrowUtils.ofNotEmpty(obj, (String)BaseResultEnum.ERROR_PARAM.getCode(), msg);
    }

    public static void ofNotEmpty(Map obj, String code, String msg) {
        if (CollectionUtil.isNotEmpty((Map)obj)) {
            ExceptionThrowUtils.of(code, msg);
        }
    }

    public static void ofNotEmpty(Map obj, BaseResultEnum resultEnum) {
        if (CollectionUtil.isNotEmpty((Map)obj)) {
            ExceptionThrowUtils.of(resultEnum);
        }
    }

    public static void ofEmpty(Collection obj) {
        ExceptionThrowUtils.ofEmpty(obj, BaseResultEnum.ERROR_PARAM);
    }

    public static void ofEmpty(Collection obj, String msg) {
        ExceptionThrowUtils.ofEmpty(obj, (String)BaseResultEnum.ERROR_PARAM.getCode(), msg);
    }

    public static void ofEmpty(Collection obj, String code, String msg) {
        if (CollectionUtil.isEmpty((Collection)obj)) {
            ExceptionThrowUtils.of(code, msg);
        }
    }

    public static void ofEmpty(Collection obj, BaseResultEnum resultEnum) {
        if (CollectionUtil.isEmpty((Collection)obj)) {
            ExceptionThrowUtils.of(resultEnum);
        }
    }

    public static void ofNotEmpty(Collection obj) {
        ExceptionThrowUtils.ofNotEmpty(obj, BaseResultEnum.ERROR_PARAM);
    }

    public static void ofNotEmpty(Collection obj, String msg) {
        ExceptionThrowUtils.ofNotEmpty(obj, (String)BaseResultEnum.ERROR_PARAM.getCode(), msg);
    }

    public static void ofNotEmpty(Collection obj, String code, String msg) {
        if (CollectionUtil.isNotEmpty((Collection)obj)) {
            ExceptionThrowUtils.of(code, msg);
        }
    }

    public static void ofNotEmpty(Collection obj, BaseResultEnum resultEnum) {
        if (CollectionUtil.isNotEmpty((Collection)obj)) {
            ExceptionThrowUtils.of(resultEnum);
        }
    }

    public static void of(String msg) {
        ExceptionThrowUtils.of((String)BaseResultEnum.ERROR_PARAM.getCode(), msg);
    }

    public static void of(String code, String msg) {
        ExceptionThrowUtils.of(code, msg, null);
    }

    public static void of(String code, String msg, Throwable cause) {
        if (StrUtil.isBlank((CharSequence)code)) {
            code = (String)BaseResultEnum.ERROR_PARAM.getCode();
        }
        ExceptionThrowUtils.of(BaseResultEnum.of(code, msg), cause);
    }

    public static void of(String msg, Throwable cause) {
        ExceptionThrowUtils.of(BaseResultEnum.of((String)BaseResultEnum.ERROR_PARAM.getCode(), msg), cause);
    }

    public static void of(BaseResultEnum resultEnum) {
        throw new BusinessException(resultEnum, null);
    }

    public static void of(BaseResultEnum resultEnum, Throwable cause) {
        throw new BusinessException(resultEnum, cause);
    }

    public static String getExceptionMessage(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        e.printStackTrace(pw);
        IoUtil.close((Closeable)pw);
        IoUtil.close((Closeable)sw);
        return sw.toString();
    }

    public static void ofBlank(String obj) {
        ExceptionThrowUtils.ofTrue((Boolean)StrUtil.isBlank((CharSequence)obj), BaseResultEnum.ERROR_PARAM);
    }

    public static void ofBlank(String obj, String msg) {
        ExceptionThrowUtils.ofTrue(StrUtil.isBlank((CharSequence)obj), (String)BaseResultEnum.ERROR_PARAM.getCode(), msg);
    }

    public static void ofBlank(String obj, String code, String msg) {
        ExceptionThrowUtils.ofTrue(StrUtil.isBlank((CharSequence)obj), code, msg);
    }

    public static void ofBlank(String obj, BaseResultEnum resultEnum) {
        ExceptionThrowUtils.ofTrue((Boolean)StrUtil.isBlank((CharSequence)obj), resultEnum);
    }

    public static void ofNotBlank(String obj) {
        ExceptionThrowUtils.ofTrue((Boolean)StrUtil.isNotBlank((CharSequence)obj), BaseResultEnum.ERROR_PARAM);
    }

    public static void ofNotBlank(String obj, String msg) {
        ExceptionThrowUtils.ofTrue(StrUtil.isNotBlank((CharSequence)obj), (String)BaseResultEnum.ERROR_PARAM.getCode(), msg);
    }

    public static void ofNotBlank(String obj, String code, String msg) {
        ExceptionThrowUtils.ofTrue(StrUtil.isNotBlank((CharSequence)obj), code, msg);
    }

    public static void ofNotBlank(String obj, BaseResultEnum resultEnum) {
        ExceptionThrowUtils.ofTrue((Boolean)StrUtil.isNotBlank((CharSequence)obj), resultEnum);
    }

    public static void ofAnyBlank(String ... obj) {
        ExceptionThrowUtils.ofTrue((Boolean)StrUtil.hasBlank((CharSequence[])obj), BaseResultEnum.ERROR_PARAM);
    }

    public static void ofAnyBlank(String msg, String ... obj) {
        ExceptionThrowUtils.ofTrue(StrUtil.hasBlank((CharSequence[])obj), (String)BaseResultEnum.ERROR_PARAM.getCode(), msg);
    }

    public static void ofAnyBlank(String code, String msg, String ... obj) {
        ExceptionThrowUtils.ofTrue(StrUtil.hasBlank((CharSequence[])obj), code, msg);
    }

    public static void ofBlank(BaseResultEnum resultEnum, String ... obj) {
        ExceptionThrowUtils.ofTrue((Boolean)StrUtil.hasBlank((CharSequence[])obj), resultEnum);
    }

    public static void ofAllBlank(String ... obj) {
        ExceptionThrowUtils.ofTrue((Boolean)StrUtil.isAllBlank((CharSequence[])obj), BaseResultEnum.ERROR_PARAM);
    }

    public static void ofAllBlank(String msg, String ... obj) {
        ExceptionThrowUtils.ofTrue(StrUtil.isAllBlank((CharSequence[])obj), (String)BaseResultEnum.ERROR_PARAM.getCode(), msg);
    }

    public static void ofAllBlank(String code, String msg, String ... obj) {
        ExceptionThrowUtils.ofTrue(StrUtil.isAllBlank((CharSequence[])obj), code, msg);
    }

    public static void ofAllBlank(BaseResultEnum resultEnum, String ... obj) {
        ExceptionThrowUtils.ofTrue((Boolean)StrUtil.isAllBlank((CharSequence[])obj), resultEnum);
    }

    public static void ofAllNotBlank(String ... obj) {
        ExceptionThrowUtils.ofTrue((Boolean)StrUtil.isAllNotBlank((CharSequence[])obj), BaseResultEnum.ERROR_PARAM);
    }

    public static void ofAllNotBlank(String msg, String ... obj) {
        ExceptionThrowUtils.ofTrue(StrUtil.isAllNotBlank((CharSequence[])obj), (String)BaseResultEnum.ERROR_PARAM.getCode(), msg);
    }

    public static void ofAllNotBlank(String code, String msg, String ... obj) {
        ExceptionThrowUtils.ofTrue(StrUtil.isAllNotBlank((CharSequence[])obj), code, msg);
    }

    public static void ofAllNotBlank(BaseResultEnum resultEnum, String ... obj) {
        ExceptionThrowUtils.ofTrue((Boolean)StrUtil.isAllNotBlank((CharSequence[])obj), resultEnum);
    }
}

