/*
 * Decompiled with CFR 0.152.
 */
package run.iget.framework.common.util;

import cn.hutool.core.util.StrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class SpringBootLauncher {
    private static final Logger log = LoggerFactory.getLogger(SpringBootLauncher.class);

    public static ConfigurableApplicationContext run(Class mainClass, String[] args) {
        ConfigurableApplicationContext applicationContext = SpringApplication.run((Class)mainClass, (String[])args);
        ConfigurableEnvironment env = applicationContext.getEnvironment();
        String applicationName = env.getProperty("spring.application.name");
        if (StrUtil.isBlank((CharSequence)applicationName)) {
            applicationName = mainClass.getSimpleName();
        }
        log.info("----------------------------------------------------------");
        log.info("Application '{}', at port {} is running!", (Object)applicationName, (Object)env.getProperty("server.port"));
        log.info("----------------------------------------------------------");
        return applicationContext;
    }
}

