/*
 * Decompiled with CFR 0.152.
 */
package run.iget.framework.common.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadTaskUtils {
    private static final int MAX_QUEUE_CAPACITY_TEN_THOUSAND = 100000;
    private static final int CORE_POOL_SIZE = 4;
    private static final int MAX_POOL_SIZE = 32;
    private static volatile ThreadPoolExecutor EXECUTE_POOL = new ThreadPoolExecutor(4, 32, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(100000), new ThreadFactoryBuilder().setNameFormat("ThreadTaskUtils-pool-%d").build());

    public static Future<?> submitTask(Runnable runnable) throws RejectedExecutionException {
        return EXECUTE_POOL.submit(runnable);
    }

    public static <T> Future<T> submitTask(Callable<T> callable) throws RejectedExecutionException {
        return EXECUTE_POOL.submit(callable);
    }
}

