/*
 * Decompiled with CFR 0.152.
 */
package run.iget.framework.common.util;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class WebUtils {
    private static final Logger log = LoggerFactory.getLogger(WebUtils.class);
    public static final String IN_LINE = "inline";
    public static final String ATTACHMENT = "attachment";

    public static HttpServletRequest getHttpServletRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return null;
        }
        return ((ServletRequestAttributes)requestAttributes).getRequest();
    }

    public static Map<String, String> getParameterMap(HttpServletRequest request) {
        Enumeration parameters = request.getParameterNames();
        HashMap<String, String> params = new HashMap<String, String>();
        while (parameters.hasMoreElements()) {
            String parameter = (String)parameters.nextElement();
            String value = request.getParameter(parameter);
            if (!StrUtil.isNotBlank((CharSequence)value)) continue;
            params.put(parameter, value);
        }
        return params;
    }

    public static String getDomain() {
        HttpServletRequest request = WebUtils.getHttpServletRequest();
        StringBuffer url = request.getRequestURL();
        return url.delete(url.length() - request.getRequestURI().length(), url.length()).toString();
    }

    public static String getOrigin() {
        HttpServletRequest request = WebUtils.getHttpServletRequest();
        return request.getHeader("Origin");
    }

    public static String getParameter(String parameterName) {
        HttpServletRequest request = WebUtils.getHttpServletRequest();
        String parameter = request.getHeader(parameterName);
        if (StrUtil.isNotBlank((CharSequence)parameter)) {
            return parameter;
        }
        parameter = request.getParameter(parameterName);
        if (StrUtil.isNotBlank((CharSequence)parameter)) {
            return parameter;
        }
        return null;
    }

    public static void responseFile(HttpServletResponse response, byte[] data, String fileName) throws IOException {
        WebUtils.responseFile(response, ATTACHMENT, "application/octet-stream", data, fileName, true);
    }

    public static void responseFile(HttpServletResponse response, String contentType, byte[] data, String fileName) throws IOException {
        WebUtils.responseFile(response, IN_LINE, contentType, data, fileName, true);
    }

    public static void responseFile(HttpServletResponse response, String downType, String contentType, byte[] data, String fileName, boolean noCache) throws IOException {
        response.reset();
        response.setHeader("Content-Disposition", downType + ";filename=" + URLEncoder.encode(fileName, "UTF-8"));
        response.addHeader("Content-Length", "" + data.length);
        response.setContentType(contentType);
        if (noCache) {
            response.setHeader("Pragma", "No-cache");
            response.setHeader("Cache-Control", "No-cache");
            response.setDateHeader("Expires", 0L);
        }
        try (BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            ((OutputStream)toClient).write(data);
            ((OutputStream)toClient).flush();
        }
    }

    public static void responseOut(HttpServletResponse response, String data) {
        WebUtils.responseOut(response, data, "application/json");
    }

    public static void responseOutWithHtml(HttpServletResponse response, String data) {
        WebUtils.responseOut(response, data, "text/html");
    }

    public static void responseOutWithJson(HttpServletResponse response, Object responseObject) {
        WebUtils.responseOut(response, JSON.toJSONString((Object)responseObject), "application/json");
    }

    public static void responseOut(HttpServletResponse response, String data, String contentType) {
        WebUtils.responseOut(response, data, contentType, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void responseOut(HttpServletResponse response, String data, String contentType, String charset) {
        response.setCharacterEncoding(charset);
        response.setContentType(contentType);
        try (PrintWriter out = null;){
            out = response.getWriter();
            out.append(data);
        }
    }

    public static void sendRedirect(HttpServletResponse response, String url) throws ServletException, IOException {
        response.setStatus(303);
        response.setHeader("Location", url);
    }
}

