/*
 * Decompiled with CFR 0.152.
 */
package run.iget.framework.desensitization.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.iget.framework.desensitization.annotation.Desensitization;
import run.iget.framework.desensitization.context.DesensitizationThreadLocalContext;

public class DesensitizeSerializer
extends JsonSerializer<String>
implements ContextualSerializer {
    private static final Logger log = LoggerFactory.getLogger(DesensitizeSerializer.class);
    private Function<String, String> desensitizationHandler;

    public DesensitizeSerializer() {
    }

    public DesensitizeSerializer(Function desensitizationHandler) {
        this.desensitizationHandler = desensitizationHandler;
    }

    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        Function function;
        log.info("---------------------------------createContextual");
        if (Objects.isNull(beanProperty)) {
            return serializerProvider.findNullValueSerializer(beanProperty);
        }
        if (Objects.equals(beanProperty.getType().getRawClass(), String.class) && (function = this.getDesensitization(beanProperty)) != null) {
            return new DesensitizeSerializer(function);
        }
        return serializerProvider.findValueSerializer(beanProperty.getType(), beanProperty);
    }

    public void serialize(String source, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (DesensitizationThreadLocalContext.isNeedDesensitization() && Objects.nonNull(this.desensitizationHandler)) {
            jsonGenerator.writeString(this.desensitizationHandler.apply(source));
        } else {
            jsonGenerator.writeString(source);
        }
    }

    private Function getDesensitization(BeanProperty beanProperty) {
        Desensitization desensitization = (Desensitization)beanProperty.getAnnotation(Desensitization.class);
        if (desensitization == null) {
            desensitization = (Desensitization)beanProperty.getContextAnnotation(Desensitization.class);
        }
        if (desensitization == null) {
            return null;
        }
        Function function = desensitization.type().getFunction();
        Class<? extends Function> handlerClass = desensitization.handler();
        if (handlerClass != null) {
            try {
                function = handlerClass.newInstance();
            }
            catch (Exception e) {
                log.error("can not newInstance", (Throwable)e);
            }
        }
        return function;
    }
}

