/*
 * Decompiled with CFR 0.152.
 */
package run.iget.framework.mail.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.util.Map;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import run.iget.framework.common.util.ThreadTaskUtils;
import run.iget.framework.mail.service.MailService;

@Service
public class MailServiceImpl
implements MailService {
    private static final Logger log = LoggerFactory.getLogger(MailServiceImpl.class);
    @Value(value="${spring.mail.username}")
    private String from;
    @Value(value="${spring.mail.nickname:''}")
    private String nickname;
    @Resource
    private JavaMailSender mailSender;

    private String encodedFrom() {
        if (StrUtil.isBlank((CharSequence)this.nickname)) {
            return this.from;
        }
        return StrUtil.utf8Str((Object)StrUtil.format((CharSequence)"{}<{}>", (Object[])new Object[]{this.nickname, this.from}));
    }

    @Override
    public void sendSimpleMail(String to, String subject, String content) {
        ThreadTaskUtils.submitTask(() -> {
            SimpleMailMessage message = new SimpleMailMessage();
            message.setTo(to);
            message.setSubject(subject);
            message.setText(content);
            message.setFrom(this.encodedFrom());
            this.mailSender.send(message);
            log.info("\u53d1\u9001SimpleMailMessage\u90ae\u4ef6\u6210\u529f");
        });
    }

    @Override
    public void sendHtmlMail(String to, String subject, String content) {
        this.sendHtmlMail(to, subject, content, null, null);
    }

    @Override
    public void sendHtmlMailOfAttachments(String to, String subject, String content, Map<String, File> attachmentFiles) {
        this.sendHtmlMail(to, subject, content, null, attachmentFiles);
    }

    @Override
    public void sendHtmlMailOfImages(String to, String subject, String content, Map<String, File> imageFiles) {
        this.sendHtmlMail(to, subject, content, imageFiles, null);
    }

    @Override
    public void sendHtmlMail(String to, String subject, String content, Map<String, File> imageFiles, Map<String, File> attachmentFiles) {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = null;
        try {
            helper = new MimeMessageHelper(message, true);
            helper.setFrom(this.encodedFrom());
            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(content, true);
            if (CollectionUtil.isNotEmpty(imageFiles)) {
                for (Map.Entry<String, File> imageEntry : imageFiles.entrySet()) {
                    helper.addInline(imageEntry.getKey(), imageEntry.getValue());
                }
            }
            if (CollectionUtil.isNotEmpty(attachmentFiles)) {
                for (Map.Entry<String, File> attachmentEntry : attachmentFiles.entrySet()) {
                    helper.addAttachment(attachmentEntry.getKey(), attachmentEntry.getValue());
                }
            }
            ThreadTaskUtils.submitTask(() -> this.mailSender.send(message));
            log.info("\u53d1\u9001HTML\u90ae\u4ef6\u6210\u529f");
        }
        catch (MessagingException e) {
            log.error("\u53d1\u9001HTML\u90ae\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    @Override
    public void sendInitPasswordEmail(String to, String url) {
    }
}

