/*
 * Decompiled with CFR 0.152.
 */
package run.iget.framework.propertity;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Objects;
import java.util.Set;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import run.iget.framework.propertity.ModuleProperties;

public class ApiPathPrefixUtils {
    public static void addApiPathPrefix(ModuleProperties properties, PathMatchConfigurer configurer, String ... controllerPackages) {
        if (Objects.isNull(controllerPackages) || controllerPackages.length == 0) {
            return;
        }
        for (String controllerPackage : controllerPackages) {
            ApiPathPrefixUtils.addApiPathPrefix(properties, configurer, controllerPackage);
        }
    }

    public static void addApiPathPrefix(ModuleProperties properties, PathMatchConfigurer configurer, Set<String> controllerPackages) {
        if (CollUtil.isEmpty(controllerPackages)) {
            return;
        }
        controllerPackages.forEach(controllerPackage -> ApiPathPrefixUtils.addApiPathPrefix(properties, configurer, controllerPackage));
    }

    public static void addApiPathPrefix(ModuleProperties properties, PathMatchConfigurer configurer, String controllerPackage) {
        if (ObjectUtil.hasNull((Object[])new Object[]{properties, configurer}) || StrUtil.hasBlank((CharSequence[])new CharSequence[]{properties.getApiPathPrefix(), controllerPackage})) {
            return;
        }
        if (!Boolean.TRUE.equals(properties.getEnable())) {
            return;
        }
        configurer.addPathPrefix(properties.getApiPathPrefix(), c -> Objects.equals(controllerPackage, c.getPackage().getName()));
    }
}

