/*
 * Decompiled with CFR 0.152.
 */
package run.qontract.core;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J(\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\u0015"}, d2={"Lrun/qontract/core/ContractFile;", "", "()V", "classPath", "", "getClassPath", "()Ljava/lang/String;", "setClassPath", "(Ljava/lang/String;)V", "downloadDirectoryName", "getDownloadDirectoryName", "setDownloadDirectoryName", "ensureDirectoryExists", "", "classLoader", "Ljava/lang/ClassLoader;", "directoryPath", "writeContractTestFile", "downloadPath", "consumer", "contractTest", "core"})
public final class ContractFile {
    @NotNull
    private static String downloadDirectoryName;
    @NotNull
    private static String classPath;
    public static final ContractFile INSTANCE;

    @NotNull
    public final String getDownloadDirectoryName() {
        return downloadDirectoryName;
    }

    public final void setDownloadDirectoryName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        downloadDirectoryName = string;
    }

    @NotNull
    public final String getClassPath() {
        return classPath;
    }

    public final void setClassPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        classPath = string;
    }

    public final void writeContractTestFile(@NotNull ClassLoader classLoader, @NotNull String downloadPath, @NotNull String consumer, @Nullable String contractTest) throws URISyntaxException, IOException {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter((Object)downloadPath, (String)"downloadPath");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this.ensureDirectoryExists(classLoader, downloadPath);
        URL filePath = classLoader.getResource(".");
        StringBuilder stringBuilder = new StringBuilder();
        URI uRI = filePath.toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"filePath.toURI()");
        File file = new File(stringBuilder.append(uRI.getPath()).append(downloadPath).append("/").append(consumer).append(".feature").toString());
        file.createNewFile();
        FileWriter writer = new FileWriter(file);
        writer.write(contractTest);
        writer.close();
    }

    public final void ensureDirectoryExists(@NotNull ClassLoader classLoader, @NotNull String directoryPath) throws URISyntaxException {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        URL filePath = classLoader.getResource(".");
        StringBuilder stringBuilder = new StringBuilder();
        URI uRI = filePath.toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"filePath.toURI()");
        File file = new File(stringBuilder.append(uRI.getPath()).append(directoryPath).toString());
        if (!file.isDirectory()) {
            file.mkdirs();
        }
    }

    private ContractFile() {
    }

    static {
        ContractFile contractFile;
        INSTANCE = contractFile = new ContractFile();
        downloadDirectoryName = "__contract_tests";
        classPath = "classpath:" + downloadDirectoryName;
    }
}

