/*
 * Decompiled with CFR 0.152.
 */
package run.qontract.core;

import io.netty.buffer.ByteBuf;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import run.qontract.core.HttpHeadersPattern;
import run.qontract.core.HttpRequest;
import run.qontract.core.HttpRequestKt;
import run.qontract.core.HttpRequestPattern;
import run.qontract.core.MultiPartFormDataPattern;
import run.qontract.core.MultiPartFormDataValue;
import run.qontract.core.URLMatcher;
import run.qontract.core.URLMatcherKt;
import run.qontract.core.pattern.ContractException;
import run.qontract.core.pattern.ExactValuePattern;
import run.qontract.core.pattern.GrammarKt;
import run.qontract.core.pattern.Pattern;
import run.qontract.core.utilities.URIUtils;
import run.qontract.core.value.EmptyStringKt;
import run.qontract.core.value.JSONArrayValue;
import run.qontract.core.value.JSONObjectValue;
import run.qontract.core.value.StringValue;
import run.qontract.core.value.Value;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001By\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J\u0015\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J\u0015\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0003J}\u0010#\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00062\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00062\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010'\u001a\u00020\u00032\b\u0010(\u001a\u0004\u0018\u00010\u0003J\t\u0010)\u001a\u00020*H\u00d6\u0001J(\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020,0\u00062\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0002J\u001a\u0010.\u001a\u00020\u00002\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006J\u0006\u00100\u001a\u000201J\u0010\u00102\u001a\u00020\u00032\b\b\u0002\u00103\u001a\u00020\u0003J\u0006\u00104\u001a\u000205J\t\u00106\u001a\u00020\u0003H\u00d6\u0001J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0002J\u0010\u00107\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003J\u000e\u00107\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u0003J\u000e\u0010>\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\u0003J\u000e\u0010@\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0003J\u0016\u0010A\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u0003J\u001a\u0010B\u001a\u00020\u00002\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006J\u000e\u0010C\u001a\u00020\u00002\u0006\u0010D\u001a\u00020EJ\u000e\u0010F\u001a\u00020\u00002\u0006\u0010G\u001a\u00020\u0003R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0013R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015\u00a8\u0006H"}, d2={"Lrun/qontract/core/HttpRequest;", "", "method", "", "path", "headers", "", "body", "Lrun/qontract/core/value/Value;", "queryParams", "formFields", "multiPartFormData", "", "Lrun/qontract/core/MultiPartFormDataValue;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Lrun/qontract/core/value/Value;Ljava/util/Map;Ljava/util/Map;Ljava/util/List;)V", "getBody", "()Lrun/qontract/core/value/Value;", "bodyString", "getBodyString", "()Ljava/lang/String;", "getFormFields", "()Ljava/util/Map;", "getHeaders", "getMethod", "getMultiPartFormData", "()Ljava/util/List;", "getPath", "getQueryParams", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "getURL", "baseURL", "hashCode", "", "mapToPattern", "Lrun/qontract/core/pattern/Pattern;", "map", "setHeaders", "addedHeaders", "toJSON", "Lrun/qontract/core/value/JSONObjectValue;", "toLogString", "prefix", "toPattern", "Lrun/qontract/core/HttpRequestPattern;", "toString", "updateBody", "", "contentBuffer", "Lio/netty/buffer/ByteBuf;", "updateHeader", "key", "value", "updateMethod", "name", "updatePath", "updateQueryParam", "updateQueryParams", "updateWith", "url", "Ljava/net/URI;", "withHost", "host", "core"})
public final class HttpRequest {
    @Nullable
    private final String method;
    @Nullable
    private final String path;
    @NotNull
    private final Map<String, String> headers;
    @NotNull
    private final Value body;
    @NotNull
    private final Map<String, String> queryParams;
    @NotNull
    private final Map<String, String> formFields;
    @NotNull
    private final List<MultiPartFormDataValue> multiPartFormData;

    @NotNull
    public final HttpRequest updateQueryParams(@NotNull Map<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        return HttpRequest.copy$default(this, null, null, null, null, MapsKt.plus(queryParams, queryParams), null, null, 111, null);
    }

    @NotNull
    public final HttpRequest withHost(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return HttpRequest.copy$default(this, null, null, MapsKt.plus(this.headers, (Pair)TuplesKt.to((Object)"Host", (Object)host)), null, null, null, null, 123, null);
    }

    @NotNull
    public final HttpRequest updatePath(@NotNull String path) {
        HttpRequest httpRequest;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            URI urlParam = new URI(path);
            httpRequest = this.updateWith(urlParam);
        }
        catch (URISyntaxException e) {
            httpRequest = HttpRequest.copy$default(this, null, path, null, null, null, null, null, 125, null);
        }
        catch (UnsupportedEncodingException e) {
            httpRequest = HttpRequest.copy$default(this, null, path, null, null, null, null, null, 125, null);
        }
        return httpRequest;
    }

    @NotNull
    public final HttpRequest updateQueryParam(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return HttpRequest.copy$default(this, null, null, null, null, MapsKt.plus(this.queryParams, (Pair)TuplesKt.to((Object)key, (Object)value)), null, null, 111, null);
    }

    @NotNull
    public final HttpRequest updateBody(@NotNull Value body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return HttpRequest.copy$default(this, null, null, null, body, null, null, null, 119, null);
    }

    @NotNull
    public final HttpRequest updateBody(@Nullable String body) {
        return HttpRequest.copy$default(this, null, null, null, GrammarKt.parsedValue(body), null, null, null, 119, null);
    }

    @NotNull
    public final HttpRequest updateWith(@NotNull URI url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String path = url.getPath();
        Map<String, String> queryParams = URIUtils.INSTANCE.parseQuery(url.getQuery());
        return HttpRequest.copy$default(this, null, path, null, null, queryParams, null, null, 109, null);
    }

    @NotNull
    public final HttpRequest updateMethod(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name;
        boolean bl = false;
        String string2 = string.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
        return HttpRequest.copy$default(this, string2, null, null, null, null, null, null, 126, null);
    }

    private final void updateBody(ByteBuf contentBuffer) {
        String bodyString = contentBuffer.toString(Charset.defaultCharset());
        this.updateBody(bodyString);
    }

    @NotNull
    public final HttpRequest updateHeader(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return HttpRequest.copy$default(this, null, null, MapsKt.plus(this.headers, (Pair)TuplesKt.to((Object)key, (Object)value)), null, null, null, null, 123, null);
    }

    @NotNull
    public final String getBodyString() {
        return this.body.toString();
    }

    @NotNull
    public final String getURL(@Nullable String baseURL) {
        String string;
        StringBuilder stringBuilder = new StringBuilder().append(baseURL).append(this.path);
        Map<String, String> map2 = this.queryParams;
        boolean bl = false;
        if (!map2.isEmpty()) {
            String joinedQueryParams2 = CollectionsKt.joinToString$default((Iterable)MapsKt.toList(this.queryParams), (CharSequence)"&", null, null, (int)0, null, (Function1)getURL.joinedQueryParams.1.INSTANCE, (int)30, null);
            string = '?' + joinedQueryParams2;
        } else {
            string = "";
        }
        return stringBuilder.append(string).toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JSONObjectValue toJSON() {
        Object destination$iv$iv;
        Iterable $this$mapValues$iv;
        boolean $i$f$mapValues;
        StringValue stringValue;
        String it;
        Map map2;
        String string;
        boolean bl;
        boolean bl2;
        Map requestMap;
        boolean bl3 = false;
        Map map3 = requestMap = (Map)new LinkedHashMap();
        String string2 = "path";
        String string3 = this.path;
        if (string3 != null) {
            String string4 = string3;
            bl2 = false;
            bl = false;
            String string5 = string4;
            string = string2;
            map2 = map3;
            boolean bl4 = false;
            StringValue stringValue2 = new StringValue(it);
            map3 = map2;
            string2 = string;
            stringValue = stringValue2;
        } else {
            stringValue = new StringValue("/");
        }
        map3.put(string2, stringValue);
        String string6 = this.method;
        if (string6 == null) {
            throw (Throwable)new ContractException("Can't serialise the request without a method.", null, null, null, 14, null);
        }
        Map<String, String> map4 = string6;
        bl2 = false;
        bl = false;
        it = map4;
        boolean bl5 = false;
        requestMap.put("method", new StringValue(it));
        HttpRequestKt.access$setIfNotEmpty(requestMap, "query", this.queryParams);
        HttpRequestKt.access$setIfNotEmpty(requestMap, "headers", this.headers);
        map4 = this.formFields;
        bl2 = false;
        if (!map4.isEmpty()) {
            Object object;
            void $this$mapValuesTo$iv$iv;
            map4 = this.formFields;
            string = "form-fields";
            map2 = requestMap;
            $i$f$mapValues = false;
            Collection collection = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it2;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Object object2 = destination$iv$iv;
                boolean bl6 = false;
                Object k = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k2 = k;
                object = object2;
                boolean bl7 = false;
                StringValue stringValue3 = new StringValue((String)it2.getValue());
                object.put(k2, stringValue3);
            }
            Object object3 = object = destination$iv$iv;
            map2.put(string, new JSONObjectValue((Map<String, ? extends Value>)object3));
        } else {
            $this$mapValues$iv = this.multiPartFormData;
            $i$f$mapValues = false;
            if (!$this$mapValues$iv.isEmpty()) {
                Object object;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                $this$mapValues$iv = this.multiPartFormData;
                string = "multipart-formdata";
                map2 = requestMap;
                boolean $i$f$map = false;
                void $this$mapValuesTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    MultiPartFormDataValue multiPartFormDataValue = (MultiPartFormDataValue)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl8 = false;
                    JSONObjectValue jSONObjectValue = it3.toJSONObject();
                    object.add(jSONObjectValue);
                }
                object = (List)destination$iv$iv;
                List list = object;
                map2.put(string, new JSONArrayValue(list));
            } else {
                requestMap.put("body", this.body);
            }
        }
        return new JSONObjectValue(requestMap);
    }

    @NotNull
    public final HttpRequest setHeaders(@NotNull Map<String, String> addedHeaders) {
        Intrinsics.checkNotNullParameter(addedHeaders, (String)"addedHeaders");
        return HttpRequest.copy$default(this, null, null, MapsKt.plus(this.headers, addedHeaders), null, null, null, null, 123, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toLogString(@NotNull String prefix) {
        String string;
        Object $this$mapTo$iv$iv;
        boolean $i$f$map;
        Object $this$map$iv;
        void $this$mapTo$iv$iv332;
        String string2;
        Collection collection;
        Map.Entry item$iv$iv2;
        void $this$mapTo$iv$iv232;
        String string3;
        String methodString;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        String string4 = this.method;
        if (string4 == null) {
            string4 = methodString = "NO_METHOD";
        }
        if ((string3 = this.path) == null) {
            string3 = "NO_PATH";
        }
        String pathString = string3;
        Object $this$map$iv2 = this.queryParams;
        boolean $i$f$map2 = false;
        Map<String, String> map2 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo = false;
        Object object = $this$mapTo$iv$iv232;
        boolean bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry entry = item$iv$iv2 = iterator.next();
            collection = destination$iv$iv;
            boolean bl22 = false;
            string2 = (String)it.getKey() + '=' + (String)it.getValue();
            collection.add(string2);
        }
        $this$map$iv2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        $i$f$map2 = false;
        boolean $this$mapTo$iv$iv232 = false;
        Object it = $this$map$iv2;
        boolean bl3 = false;
        object = (CharSequence)it;
        bl = false;
        Object queryParamString = object.length() > 0 ? '?' + (String)it : it;
        String urlString = pathString + (String)queryParamString;
        String firstLine = methodString + ' ' + urlString;
        Map<String, String> $this$map$iv3 = this.headers;
        boolean $i$f$map2232 = false;
        object = $this$map$iv3;
        Object destination$iv$iv2 = new ArrayList($this$map$iv3.size());
        boolean $i$f$mapTo2 = false;
        item$iv$iv2 = $this$mapTo$iv$iv332;
        boolean bl4 = false;
        Iterator bl22 = item$iv$iv2.entrySet().iterator();
        while (bl22.hasNext()) {
            void it2;
            Map.Entry entry;
            Map.Entry entry2 = entry = bl22.next();
            collection = destination$iv$iv2;
            boolean bl5 = false;
            string2 = (String)it2.getKey() + ": " + (String)it2.getValue();
            collection.add(string2);
        }
        String headerString2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        Map<String, String> $i$f$map2232 = this.formFields;
        boolean $this$mapTo$iv$iv332 = false;
        if (!$i$f$map2232.isEmpty()) {
            $this$map$iv = this.formFields;
            $i$f$map = false;
            destination$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo3 = false;
            void var14_28 = $this$mapTo$iv$iv;
            boolean bl22 = false;
            Iterator iterator2 = var14_28.entrySet().iterator();
            while (iterator2.hasNext()) {
                void it3;
                Map.Entry item$iv$iv4;
                Map.Entry bl5 = item$iv$iv4 = iterator2.next();
                collection = destination$iv$iv3;
                boolean bl6 = false;
                string2 = (String)it3.getKey() + '=' + (String)it3.getValue();
                collection.add(string2);
            }
            string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv3), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        } else {
            $this$map$iv = this.multiPartFormData;
            $i$f$map = false;
            if (!$this$map$iv.isEmpty()) {
                $this$map$iv = this.multiPartFormData;
                boolean $i$f$map3 = false;
                $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo4 = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object item$iv$iv5 = iterator2.next();
                    MultiPartFormDataValue multiPartFormDataValue = (MultiPartFormDataValue)item$iv$iv5;
                    collection = destination$iv$iv4;
                    boolean bl7 = false;
                    string2 = multiPartFormDataValue.toDisplayableValue();
                    collection.add(string2);
                }
                string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv4), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            } else {
                string = this.body.toString();
            }
        }
        String bodyString = string;
        String $i$f$map3 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])new String[]{firstLine, headerString2}), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        boolean bl8 = false;
        String string5 = $i$f$map3;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String firstPart = ((Object)StringsKt.trim((CharSequence)string5)).toString();
        String requestString = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])new String[]{firstPart, "", bodyString}), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        return HttpRequestKt.startLinesWith(requestString, prefix);
    }

    public static /* synthetic */ String toLogString$default(HttpRequest httpRequest, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return httpRequest.toLogString(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HttpRequestPattern toPattern() {
        Collection<MultiPartFormDataPattern> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string = this.path;
        if (string == null) {
            string = "/";
        }
        String pathForPattern = string;
        Iterable iterable = this.multiPartFormData;
        Map<String, Pattern> map2 = this.mapToPattern(this.formFields);
        Pattern pattern = this.body.exactMatchElseType();
        String string2 = this.method;
        URLMatcher uRLMatcher = new URLMatcher(this.mapToPattern(this.queryParams), URLMatcherKt.pathToPattern(pathForPattern), pathForPattern);
        HttpHeadersPattern httpHeadersPattern = new HttpHeadersPattern(this.mapToPattern(this.headers), null, 2, null);
        boolean $i$f$map = false;
        void var4_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MultiPartFormDataValue multiPartFormDataValue = (MultiPartFormDataValue)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            MultiPartFormDataPattern multiPartFormDataPattern = it.inferType();
            collection.add(multiPartFormDataPattern);
        }
        Collection<MultiPartFormDataPattern> collection2 = collection = (List)destination$iv$iv;
        Map<String, Pattern> map3 = map2;
        Pattern pattern2 = pattern;
        String string3 = string2;
        URLMatcher uRLMatcher2 = uRLMatcher;
        HttpHeadersPattern httpHeadersPattern2 = httpHeadersPattern;
        return new HttpRequestPattern(httpHeadersPattern2, uRLMatcher2, string3, pattern2, (Map<String, ? extends Pattern>)map3, (List<? extends MultiPartFormDataPattern>)collection2);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Pattern> mapToPattern(Map<String, String> map2) {
        void $this$mapValuesTo$iv$iv;
        Map<String, String> $this$mapValues$iv = map2;
        boolean $i$f$mapValues = false;
        Map<String, String> map3 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $dstr$_u24__u24$value;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map5 = map4;
            boolean bl2 = false;
            void var17_17 = $dstr$_u24__u24$value;
            boolean bl3 = false;
            String value = (String)var17_17.getValue();
            Pattern pattern = GrammarKt.isPatternToken(value) ? GrammarKt.parsedPattern$default(value, null, null, 6, null) : (Pattern)new ExactValuePattern(new StringValue(value), null, 2, null);
            map5.put(k2, pattern);
        }
        return destination$iv$iv;
    }

    @Nullable
    public final String getMethod() {
        return this.method;
    }

    @Nullable
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final Map<String, String> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final Value getBody() {
        return this.body;
    }

    @NotNull
    public final Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    @NotNull
    public final Map<String, String> getFormFields() {
        return this.formFields;
    }

    @NotNull
    public final List<MultiPartFormDataValue> getMultiPartFormData() {
        return this.multiPartFormData;
    }

    public HttpRequest(@Nullable String method, @Nullable String path, @NotNull Map<String, String> headers, @NotNull Value body, @NotNull Map<String, String> queryParams, @NotNull Map<String, String> formFields, @NotNull List<? extends MultiPartFormDataValue> multiPartFormData) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        Intrinsics.checkNotNullParameter(formFields, (String)"formFields");
        Intrinsics.checkNotNullParameter(multiPartFormData, (String)"multiPartFormData");
        this.method = method;
        this.path = path;
        this.headers = headers;
        this.body = body;
        this.queryParams = queryParams;
        this.formFields = formFields;
        this.multiPartFormData = multiPartFormData;
    }

    public /* synthetic */ HttpRequest(String string, String string2, Map map2, Value value, Map map3, Map map4, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            value = EmptyStringKt.getEmptyString();
        }
        if ((n & 0x10) != 0) {
            map3 = MapsKt.emptyMap();
        }
        if ((n & 0x20) != 0) {
            map4 = MapsKt.emptyMap();
        }
        if ((n & 0x40) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, string2, map2, value, map3, map4, list);
    }

    public HttpRequest() {
        this(null, null, null, null, null, null, null, 127, null);
    }

    @Nullable
    public final String component1() {
        return this.method;
    }

    @Nullable
    public final String component2() {
        return this.path;
    }

    @NotNull
    public final Map<String, String> component3() {
        return this.headers;
    }

    @NotNull
    public final Value component4() {
        return this.body;
    }

    @NotNull
    public final Map<String, String> component5() {
        return this.queryParams;
    }

    @NotNull
    public final Map<String, String> component6() {
        return this.formFields;
    }

    @NotNull
    public final List<MultiPartFormDataValue> component7() {
        return this.multiPartFormData;
    }

    @NotNull
    public final HttpRequest copy(@Nullable String method, @Nullable String path, @NotNull Map<String, String> headers, @NotNull Value body, @NotNull Map<String, String> queryParams, @NotNull Map<String, String> formFields, @NotNull List<? extends MultiPartFormDataValue> multiPartFormData) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        Intrinsics.checkNotNullParameter(formFields, (String)"formFields");
        Intrinsics.checkNotNullParameter(multiPartFormData, (String)"multiPartFormData");
        return new HttpRequest(method, path, headers, body, queryParams, formFields, multiPartFormData);
    }

    public static /* synthetic */ HttpRequest copy$default(HttpRequest httpRequest, String string, String string2, Map map2, Value value, Map map3, Map map4, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = httpRequest.method;
        }
        if ((n & 2) != 0) {
            string2 = httpRequest.path;
        }
        if ((n & 4) != 0) {
            map2 = httpRequest.headers;
        }
        if ((n & 8) != 0) {
            value = httpRequest.body;
        }
        if ((n & 0x10) != 0) {
            map3 = httpRequest.queryParams;
        }
        if ((n & 0x20) != 0) {
            map4 = httpRequest.formFields;
        }
        if ((n & 0x40) != 0) {
            list = httpRequest.multiPartFormData;
        }
        return httpRequest.copy(string, string2, map2, value, map3, map4, list);
    }

    @NotNull
    public String toString() {
        return "HttpRequest(method=" + this.method + ", path=" + this.path + ", headers=" + this.headers + ", body=" + this.body + ", queryParams=" + this.queryParams + ", formFields=" + this.formFields + ", multiPartFormData=" + this.multiPartFormData + ")";
    }

    public int hashCode() {
        String string = this.method;
        String string2 = this.path;
        Map<String, String> map2 = this.headers;
        Value value = this.body;
        Map<String, String> map3 = this.queryParams;
        Map<String, String> map4 = this.formFields;
        List<MultiPartFormDataValue> list = this.multiPartFormData;
        return ((((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (map2 != null ? ((Object)map2).hashCode() : 0)) * 31 + (value != null ? value.hashCode() : 0)) * 31 + (map3 != null ? ((Object)map3).hashCode() : 0)) * 31 + (map4 != null ? ((Object)map4).hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof HttpRequest)) break block3;
                HttpRequest httpRequest = (HttpRequest)object;
                if (!Intrinsics.areEqual((Object)this.method, (Object)httpRequest.method) || !Intrinsics.areEqual((Object)this.path, (Object)httpRequest.path) || !Intrinsics.areEqual(this.headers, httpRequest.headers) || !Intrinsics.areEqual((Object)this.body, (Object)httpRequest.body) || !Intrinsics.areEqual(this.queryParams, httpRequest.queryParams) || !Intrinsics.areEqual(this.formFields, httpRequest.formFields) || !Intrinsics.areEqual(this.multiPartFormData, httpRequest.multiPartFormData)) break block3;
            }
            return true;
        }
        return false;
    }
}

