/*
 * Decompiled with CFR 0.152.
 */
package run.qontract.core;

import io.ktor.http.HttpStatusCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import run.qontract.core.HttpRequestKt;
import run.qontract.core.HttpResponseKt;
import run.qontract.core.pattern.ContractException;
import run.qontract.core.pattern.GrammarKt;
import run.qontract.core.value.EmptyStringKt;
import run.qontract.core.value.JSONObjectValue;
import run.qontract.core.value.NullValue;
import run.qontract.core.value.NumberValue;
import run.qontract.core.value.StringValue;
import run.qontract.core.value.Value;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B3\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\bB/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007\u0012\b\b\u0002\u0010\u0004\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J3\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00072\b\b\u0002\u0010\u0004\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u00052\b\b\u0002\u0010\u001f\u001a\u00020\u0005J\t\u0010 \u001a\u00020\u0005H\u00d6\u0001J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006$"}, d2={"Lrun/qontract/core/HttpResponse;", "", "status", "", "body", "", "headers", "", "(ILjava/lang/String;Ljava/util/Map;)V", "Lrun/qontract/core/value/Value;", "(ILjava/util/Map;Lrun/qontract/core/value/Value;)V", "getBody", "()Lrun/qontract/core/value/Value;", "getHeaders", "()Ljava/util/Map;", "getStatus", "()I", "statusText", "getStatusText", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toJSON", "Lrun/qontract/core/value/JSONObjectValue;", "toLogString", "prefix", "toString", "updateBodyWith", "content", "Companion", "core"})
public final class HttpResponse {
    private final int status;
    @NotNull
    private final Map<String, String> headers;
    @NotNull
    private final Value body;
    @NotNull
    private static final HttpResponse ERROR_400;
    @NotNull
    private static final HttpResponse OK;
    @NotNull
    private static final HttpResponse EMPTY;
    public static final Companion Companion;

    private final String getStatusText() {
        String string;
        switch (this.status) {
            case 0: {
                string = "";
                break;
            }
            default: {
                string = HttpStatusCode.Companion.fromValue(this.status).getDescription();
            }
        }
        return string;
    }

    @NotNull
    public final HttpResponse updateBodyWith(@NotNull Value content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Map map2 = MapsKt.plus((Map)MapsKt.minus(this.headers, (Object)"Content-Type"), (Pair)TuplesKt.to((Object)"Content-Type", (Object)content.getHttpContentType()));
        Value value = content;
        return HttpResponse.copy$default(this, 0, map2, value, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JSONObjectValue toJSON() {
        boolean bl = false;
        Map map2 = new LinkedHashMap();
        boolean bl2 = false;
        boolean bl3 = false;
        Map json = map2;
        boolean bl4 = false;
        json.put("status", new NumberValue(this.status));
        json.put("body", this.body);
        Map<String, String> map3 = this.getStatusText();
        boolean bl5 = false;
        if (map3.length() > 0) {
            json.put("status-text", new StringValue(this.getStatusText()));
        }
        map3 = this.headers;
        bl5 = false;
        if (!map3.isEmpty()) {
            Map map4;
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            map3 = this.headers;
            String string = "headers";
            Map map5 = json;
            boolean $i$f$mapValues = false;
            void var12_11 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map6 = destination$iv$iv;
                boolean bl6 = false;
                Object k = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k2 = k;
                map4 = map6;
                boolean bl7 = false;
                StringValue stringValue = new StringValue((String)it.getValue());
                map4.put(k2, stringValue);
            }
            Map map7 = map4 = destination$iv$iv;
            map5.put(string, new JSONObjectValue(map7));
        }
        Unit unit = Unit.INSTANCE;
        Map map8 = map2;
        return new JSONObjectValue(map8);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toLogString(@NotNull String prefix) {
        void $this$mapTo$iv$iv22;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        String statusLine = "" + this.status + ' ' + this.getStatusText();
        Map<String, String> $this$map$iv = this.headers;
        boolean $i$f$map22 = false;
        Map<String, String> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var9_11 = $this$mapTo$iv$iv22;
        boolean bl = false;
        Iterator iterator = var9_11.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String string = (String)it.getKey() + ": " + (String)it.getValue();
            collection.add(string);
        }
        String headerString2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        String $i$f$map22 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])new String[]{statusLine, headerString2}), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        boolean $this$mapTo$iv$iv22 = false;
        String string = $i$f$map22;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String firstPart = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String formattedBody = this.body.toStringValue();
        String responseString = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])new String[]{firstPart, "", formattedBody}), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        return HttpRequestKt.startLinesWith(responseString, prefix);
    }

    public static /* synthetic */ String toLogString$default(HttpResponse httpResponse2, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return httpResponse2.toLogString(string);
    }

    public final int getStatus() {
        return this.status;
    }

    @NotNull
    public final Map<String, String> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final Value getBody() {
        return this.body;
    }

    public HttpResponse(int status, @NotNull Map<String, String> headers, @NotNull Value body) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this.status = status;
        this.headers = headers;
        this.body = body;
    }

    public /* synthetic */ HttpResponse(int n, Map map2, Value value, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)"text/plain"));
        }
        if ((n2 & 4) != 0) {
            value = EmptyStringKt.getEmptyString();
        }
        this(n, map2, value);
    }

    public HttpResponse() {
        this(0, (Map)null, (Value)null, 7, (DefaultConstructorMarker)null);
    }

    /*
     * WARNING - void declaration
     */
    public HttpResponse(int status, @Nullable String body, @NotNull Map<String, String> headers) {
        Object object;
        Map<String, String> map2;
        int n;
        HttpResponse httpResponse2;
        block3: {
            block2: {
                void it;
                Intrinsics.checkNotNullParameter(headers, (String)"headers");
                httpResponse2 = this;
                n = status;
                map2 = headers;
                object = body;
                if (object == null) break block2;
                String string = object;
                boolean bl = false;
                boolean bl2 = false;
                String string2 = string;
                Map<String, String> map3 = map2;
                int n2 = n;
                HttpResponse httpResponse3 = httpResponse2;
                boolean bl3 = false;
                Value value = GrammarKt.parsedValue((String)it);
                httpResponse2 = httpResponse3;
                n = n2;
                map2 = map3;
                object = value;
                if (object != null) break block3;
            }
            object = EmptyStringKt.getEmptyString();
        }
        httpResponse2(n, map2, (Value)object);
    }

    public /* synthetic */ HttpResponse(int n, String string, Map map2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            string = "";
        }
        if ((n2 & 4) != 0) {
            map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)"text/plain"));
        }
        this(n, string, map2);
    }

    static {
        Companion = new Companion(null);
        ERROR_400 = new HttpResponse(400, "This request did not match any scenario.", MapsKt.emptyMap());
        OK = new HttpResponse(200, MapsKt.emptyMap(), null, 4, null);
        EMPTY = new HttpResponse(0, MapsKt.emptyMap(), null, 4, null);
    }

    public final int component1() {
        return this.status;
    }

    @NotNull
    public final Map<String, String> component2() {
        return this.headers;
    }

    @NotNull
    public final Value component3() {
        return this.body;
    }

    @NotNull
    public final HttpResponse copy(int status, @NotNull Map<String, String> headers, @NotNull Value body) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return new HttpResponse(status, headers, body);
    }

    public static /* synthetic */ HttpResponse copy$default(HttpResponse httpResponse2, int n, Map map2, Value value, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = httpResponse2.status;
        }
        if ((n2 & 2) != 0) {
            map2 = httpResponse2.headers;
        }
        if ((n2 & 4) != 0) {
            value = httpResponse2.body;
        }
        return httpResponse2.copy(n, map2, value);
    }

    @NotNull
    public String toString() {
        return "HttpResponse(status=" + this.status + ", headers=" + this.headers + ", body=" + this.body + ")";
    }

    public int hashCode() {
        Map<String, String> map2 = this.headers;
        Value value = this.body;
        return (Integer.hashCode(this.status) * 31 + (map2 != null ? ((Object)map2).hashCode() : 0)) * 31 + (value != null ? value.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof HttpResponse)) break block3;
                HttpResponse httpResponse2 = (HttpResponse)object;
                if (this.status != httpResponse2.status || !Intrinsics.areEqual(this.headers, httpResponse2.headers) || !Intrinsics.areEqual((Object)this.body, (Object)httpResponse2.body)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\rJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u000eJ\u001a\u0010\u000f\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\rJ\u001a\u0010\u0013\u001a\u00020\u00042\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u0015J\u0010\u0010\u0016\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u0018\u001a\u00020\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lrun/qontract/core/HttpResponse$Companion;", "", "()V", "EMPTY", "Lrun/qontract/core/HttpResponse;", "getEMPTY", "()Lrun/qontract/core/HttpResponse;", "ERROR_400", "getERROR_400", "OK", "getOK", "body", "", "", "Lrun/qontract/core/value/Value;", "bodyToHttpResponse", "status", "", "from", "fromJSON", "jsonObject", "", "jsonResponse", "jsonData", "xmlResponse", "xmlData", "core"})
    public static final class Companion {
        @NotNull
        public final HttpResponse getERROR_400() {
            return ERROR_400;
        }

        @NotNull
        public final HttpResponse getOK() {
            return OK;
        }

        @NotNull
        public final HttpResponse OK(@NotNull Number body) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            NumberValue bodyValue = new NumberValue(body);
            return new HttpResponse(200, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)bodyValue.getHttpContentType())), bodyValue);
        }

        @NotNull
        public final HttpResponse OK(@NotNull String body) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            StringValue bodyValue = new StringValue(body);
            return new HttpResponse(200, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)bodyValue.getHttpContentType())), bodyValue);
        }

        @NotNull
        public final HttpResponse OK(@NotNull Value body) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            return new HttpResponse(200, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)body.getHttpContentType())), body);
        }

        @NotNull
        public final HttpResponse getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final HttpResponse jsonResponse(@Nullable String jsonData) {
            return new HttpResponse(200, jsonData, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)"application/json")));
        }

        @NotNull
        public final HttpResponse xmlResponse(@Nullable String xmlData) {
            return new HttpResponse(200, xmlData, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)"application/xml")));
        }

        @NotNull
        public final HttpResponse from(int status, @Nullable String body) {
            return this.bodyToHttpResponse(body, status);
        }

        private final HttpResponse bodyToHttpResponse(String body, int status) {
            Value bodyValue = GrammarKt.parsedValue(body);
            return new HttpResponse(status, MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"Content-Type", (Object)bodyValue.getHttpContentType())}), bodyValue);
        }

        @NotNull
        public final HttpResponse fromJSON(@NotNull Map<String, ? extends Value> jsonObject) {
            Intrinsics.checkNotNullParameter(jsonObject, (String)"jsonObject");
            Value body = jsonObject.get("body");
            if (body instanceof NullValue) {
                throw (Throwable)new ContractException("Either body should have a value or the key should be absent from http-request", null, null, null, 14, null);
            }
            Integer n = HttpResponseKt.nativeInteger(jsonObject, "status");
            if (n == null) {
                throw (Throwable)new ContractException("http-response must contain a key named status, whose value is the http status in the response", null, null, null, 14, null);
            }
            return new HttpResponse((int)n, MapsKt.toMutableMap(HttpRequestKt.nativeStringStringMap(jsonObject, "headers")), jsonObject.getOrDefault("body", new StringValue(null, 1, null)));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

