/*
 * Decompiled with CFR 0.152.
 */
package run.qontract.core;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.jetbrains.annotations.NotNull;
import run.qontract.core.utilities.Utilities;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u001c\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002*X\u0010\r\")\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00070\u000e2)\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00070\u000e\u00a8\u0006\u0011"}, d2={"createConsumer", "Lorg/apache/kafka/clients/consumer/Consumer;", "", "brokers", "commit", "", "createProducer", "Lorg/apache/kafka/clients/producer/Producer;", "createTopics", "", "topics", "", "bootstrapServers", "CreateProducerPredicate", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "core"})
public final class QontractKafkaKt {
    @NotNull
    public static final Consumer<String, String> createConsumer(@NotNull String brokers, boolean commit) {
        Intrinsics.checkNotNullParameter((Object)brokers, (String)"brokers");
        Properties props = new Properties();
        ((Map)props).put("bootstrap.servers", brokers);
        ((Map)props).put("group.id", "qontract");
        ((Map)props).put("key.deserializer", StringDeserializer.class);
        ((Map)props).put("value.deserializer", StringDeserializer.class);
        ((Map)props).put("auto.offset.reset", "earliest");
        if (!commit) {
            ((Map)props).put("enable.auto.commit", "false");
        }
        return (Consumer)new KafkaConsumer(props);
    }

    @NotNull
    public static final Producer<String, String> createProducer(@NotNull String brokers) {
        Intrinsics.checkNotNullParameter((Object)brokers, (String)"brokers");
        Properties props = new Properties();
        ((Map)props).put("bootstrap.servers", brokers);
        ((Map)props).put("key.serializer", StringSerializer.class.getCanonicalName());
        ((Map)props).put("value.serializer", StringSerializer.class.getCanonicalName());
        return (Producer)new KafkaProducer(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void createTopics(@NotNull List<String> topics, @NotNull String bootstrapServers) {
        Intrinsics.checkNotNullParameter(topics, (String)"topics");
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        AutoCloseable autoCloseable = (AutoCloseable)AdminClient.create((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"bootstrap.servers", (Object)bootstrapServers)));
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            AdminClient adminClient = (AdminClient)autoCloseable;
            boolean bl3 = false;
            for (String topic : topics) {
                try {
                    KafkaFuture topicCreationResult;
                    CreateTopicsResult createTopicFuture = adminClient.createTopics((Collection)CollectionsKt.listOf((Object)new NewTopic(topic, 1, 1)));
                    KafkaFuture kafkaFuture = topicCreationResult = (KafkaFuture)createTopicFuture.values().get(topic);
                    if (kafkaFuture == null) continue;
                    Void cfr_ignored_0 = (Void)kafkaFuture.get();
                }
                catch (Throwable e) {
                    String string = "Couldn't create topic " + topic + ": " + Utilities.exceptionCauseMessage(e);
                    boolean bl4 = false;
                    System.out.println((Object)string);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }
}

